import logger from '../utilities/logger';

import api from '../api';

function run(): void {
    api.telegraf.start(async ctx => {
        try {
            const username = ctx.message.from.username;

            if (!username) {
                await ctx.reply('Заполни "username" в своем профиле телеграм');

                return;
            }

            await api.storage.saveChatIdByAccount(
                username,
                ctx.message.chat.id,
            );

            await ctx.reply(
                'Отлично! Теперь чувак сможет информировать тебя о важных изменениях)',
            );
        } catch (err) {
            if (err instanceof Error) {
                logger.logError('не удалось добавить пользователя', err);
            }

            await ctx.reply(
                'Что-то пошло не так. Никто об этом не знает и фиксить не будет.',
            );
        }
    });

    api.telegraf.launch();
}

export default {
    run,
};
