export enum EEnvironmentVariables {
    S3_ACCESS_KEYS = 'S3_ACCESS_KEYS',
    ABC_OAUTH_TOKEN = 'ABC_OAUTH_TOKEN',
    STAFF_OAUTH_TOKEN = 'STAFF_OAUTH_TOKEN',
    STARTREK_OAUTH_TOKEN = 'STARTREK_OAUTH_TOKEN',
    TELEGRAM_TOKEN = 'TELEGRAM_TOKEN',
    TELEGRAM_DUTY_CHAT_ID = 'TELEGRAM_DUTY_CHAT_ID',
    CHAT_IDS_BUCKET = 'CHAT_IDS_BUCKET',
    APP_VERSION = 'APP_VERSION',
    APP_ENV = 'APP_ENV',
    LOG_LEVEL = 'LOG_LEVEL',
}

export default function getEnvVariable(
    variableName: EEnvironmentVariables,
    defaultValue?: string,
): string {
    const value = process.env[variableName];

    if (value) {
        return value;
    }

    if (defaultValue !== undefined) {
        return defaultValue;
    }

    throw new Error(`Environment variable "${variableName}" is not defined`);
}
