const escapedSymbols = [
    '_',
    '*',
    '[',
    ']',
    '(',
    ')',
    '~',
    '`',
    '>',
    '#',
    '+',
    '-',
    '=',
    '|',
    '{',
    '}',
    '.',
    '!',
];

export default function escape(text: string): string {
    return text
        .split('')
        .map(symbol => {
            if (escapedSymbols.includes(symbol)) {
                return `\\${symbol}`;
            }

            return symbol;
        })
        .join('');
}
