#!/usr/bin/env node

function boom(err) {
	console.error(err);
	process.exit(1);
}

(async function() {
	const argv = require('minimist')(process.argv.slice(2));
	const {cn, ...commandArgs} = argv;
	const command = require('../src/commands')[cn];

	if (command) {
		try {
			console.log(await command(commandArgs));
		} catch (e) {
			boom(e);
		}
	} else {
		boom(new Error(`Unknown command: ${cn}`));
	}
})();

