const baseConfig = {
    github: {
        token: process.env.GITHUB_TOKEN,
        baseUrl: 'https://github.yandex-team.ru/api/v3'
    },
    startrek: {
        token: process.env.STARTRACK_TOKEN,
        baseUrl: 'https://st-api.yandex-team.ru/v2'
    },
    teamcity: {
        token: process.env.TEAMCITY_TOKEN,
        baseUrl: 'https://teamcity.yandex-team.ru/app/rest'
    }
};

let customConfig = {};

module.exports = {
    updateConfig(config) {
        customConfig = config;
    },
    getConfig() {
        return {
            ...baseConfig,
            ...customConfig
        }
    }
};
