const got = require('got');

const {getConfig} = require('../../configs');

class HttpClient {
    constructor (apiName) {
        this.apiName = apiName;
    }

    buildOptions(options = {}) {
        // требуется динамический доступ к конфигу, т.к. может быть переопределён на лету
        const {[this.apiName]: {baseUrl, token}} = getConfig();

        return {
            responseType: 'json',
            prefixUrl: baseUrl,
            ...options,
            headers: {
                Authorization: `OAuth ${token}`
            }
        };
    }

    get(url, options, followRedirect) {
        return this.execute(
            got(url, this.buildOptions(options)),
            followRedirect
        );
    }

    post(url, data, options) {
        return this.execute(
            got.post(url, this.buildOptions({
                ...options,
                body: data ? JSON.stringify(data) : undefined,
            }))
        );
    }

    async execute(request, followRedirect) {
        const response = await request;

        return followRedirect !== false
            ? response.body
            : response;
    }
}

module.exports = (apiName) => new HttpClient(apiName);
