const client = require('../api-request')('startrek');

module.exports = {
	self: (fullUrl) => client.get(fullUrl, {prefixUrl: ''}),
	getSprints: (boardId) => client.get(`boards/${boardId}/sprints`),
	findIssues: ({filter}) => client.post('issues/_search?perPage=100', {filter}),
	createIssue: (options) => client.post('issues', options),
	getIssueTransitions: (id) => client.get(`issues/${id}/transitions`),
	getIssueRemoteLinks: (issueNumber) => client.get(`issues/${issueNumber}/remotelinks`),
	applyIssueTransition: (issueId, transitionId) => client.post(`issues/${issueId}/transitions/${transitionId}/_execute`),
	addComment: (id, options) => client.post(`issues/${id}/comments`, options)
};
