const isGithubLink = require('../../utils/isGithubLink');

const {startrack, github} = require('../../api');

module.exports = async ({
    st_issue_key,
    git_labels
}) => {
    const githubClient = github();
    const links = await startrack.getIssueRemoteLinks(st_issue_key);
    const gitLinks = links.filter(isGithubLink);

    await Promise.all(gitLinks.map(async link => {
        const { id } = await startrack.self(link.object.self);
        const [rawOwner, repo, issue_number] = id.split('/');
        const owner = rawOwner.split(':').pop();

        try {
            await githubClient.rest.issues.addLabels({
                owner,
                repo,
                issue_number,
                labels: git_labels.split(',')
            });
        } catch (err) {
            console.error("can't add label: ", err && err.code);
        }
    }));
};
