const {startrack} = require('../../api');

module.exports = async ({
    st_issue,
    st_status
}) => {
    if (!st_issue) {
        throw new Error('Не указан идентификатор задачи');
    }

    if (!st_status) {
        throw new Error('Необходимо указать статус задачи');
    }

    const transitions = await startrack.getIssueTransitions(st_issue);
    const actions = transitions.map(({id}) => id);

    if (!actions.includes(st_status)) {
        throw new Error(`Невозможно сменить статус на ${st_status}. Доступные статусы: ${actions.join(', ')}`);
    }

    await startrack.applyIssueTransition(st_issue, st_status);
};
