const {github} = require('../../api');

module.exports = async (props) => {
    const githubClient = github();
    const baseGitParams = {
        owner: props.git_owner || process.env.GITHUB_OWNER,
        repo: props.git_repo || process.env.GITHUB_REPO
    };

    const {
        data: {html_url, number}
    } = await githubClient.rest.pulls.create({
        ...baseGitParams,
        head: props.git_head,
        base: props.git_base,
        title: props.git_title,
        body: props.git_body
    });

    if (props.git_labels) {
        try {
            await githubClient.rest.issues.addLabels({
                ...baseGitParams,
                issue_number: number,
                labels: props.git_labels.split(',')
            });
        } catch (e) {
            console.error('Не удалось добавить лейблы: ', e && e.code);
        }
    }

    return html_url;
};
