/* eslint-disable security/detect-non-literal-regexp */
const {DateTime} = require('luxon');

const {startrack} = require('../../api');

module.exports = async props => {
    const issue = await startrack.createIssue({
        queue: props.st_queue || process.env.STARTRACK_QUEUE,
        tags: ['release'],
        type: {
            name: 'Релиз',
        },
        summary: `Релиз ${DateTime.local().toFormat('dd.LL.yyyy')}`,
        description: [
            props.static_description ||
            process.env.STARTRACK_ISSUE_STATIC_DESCRIPTION,
        ]
            .filter(Boolean)
            .join('\n'),
    });

    return issue.key;
};
