const {github} = require('../../api');

module.exports = async props => {
    const githubClient = github();

    const owner = props.git_owner || process.env.GITHUB_OWNER;
    const repo = props.git_repo || process.env.GITHUB_REPO;

    try {
        const {data} = await githubClient.rest.pulls.list({
            owner,
            repo,
            head: `${owner}:${props.git_branch}`,
            page: 1,
            per_page: 100,
            state: 'open',
        });

        const [pullRequest] = data;

        if (!pullRequest) {
            return null;
        }

        return pullRequest.html_url;
    } catch (e) {
        console.error(e);

        return null;
    }
};
