const {ISSUE_STATUS} = require('../../api/startrack/constants');

const {startrack} = require('../../api');

module.exports = async ({st_queue = process.env.STARTRACK_QUEUE}) => {
    const issues = await startrack.findIssues({
        filter: {
            queue: st_queue,
            tags: ['release'],
            status: ISSUE_STATUS.CLOSED,
        },
    });

    const [release] = issues.sort(({statusStartTime}) => statusStartTime);

    if (!release) {
        throw new Error('Нет закрытых релизов');
    }

    return release.key;
};
