const {ISSUE_STATUS} = require('../../api/startrack/constants');

const getCurrentSprint = require('../../utils/getCurrentSprint');

const {startrack} = require('../../api');

const ACTIVE_ISSUE_STATUSES = [
    ISSUE_STATUS.OPEN,
    ISSUE_STATUS.TESTED,
    ISSUE_STATUS.TESTING,
    ISSUE_STATUS.DEPLOYED,
    ISSUE_STATUS.PRESTABLE,
    ISSUE_STATUS.IN_REVIEW,
    ISSUE_STATUS.IN_PROGRESS,
    ISSUE_STATUS.CHECK_FAILED,
    ISSUE_STATUS.READY_FOR_TEST,
    ISSUE_STATUS.TESTING_BY_ASESSORS,
];

module.exports = async ({
    st_queue = process.env.STARTRACK_QUEUE,
    st_board = process.env.STARTRACK_BOARD_ID,
}) => {
    const sprint = await getCurrentSprint(st_board);
    const issues = await startrack.findIssues({
        filter: {
            queue: st_queue,
            sprint: sprint.key,
            tags: ['release'],
            status: ACTIVE_ISSUE_STATUSES
        }
    });
    const releases = issues.filter(({tags}) => !tags.includes('hotfix'));

    if (!releases.length) {
        throw new Error('Нет активных релизов');
    }

    if (releases.length > 1) {
        throw new Error(`Найдено несколько релизов: ${releases.map(({key}) => key).join(', ')}`);
    }

    return releases[0].key;
};
