const {github} = require('../../api');

module.exports = async (props) => {
    const githubClient = github();

    try {
        const {status} = await githubClient.rest.repos.merge({
            owner: props.git_owner || process.env.GITHUB_OWNER,
            repo: props.git_repo || process.env.GITHUB_REPO,
            head: props.git_head,
            base: props.git_base
        });

        console.log('merge-pr status: ', status);

        return status === 201;
    } catch (err) {
        console.error('merge-pr error: ', err);

        return false;
    }
};
