const isGithubLink = require('../../utils/isGithubLink');

const {startrack, github} = require('../../api');

module.exports = async ({
    st_issue_key,
    git_labels,
}) => {
    const githubClient = github();
    const links = await startrack.getIssueRemoteLinks(st_issue_key);
    const gitLinks = links.filter(isGithubLink);

    await Promise.all(gitLinks.map(async link => {
        const { id } = await startrack.self(link.object.self);
        const [rawOwner, repo, issue_number] = id.split('/');
        const owner = rawOwner.split(':').pop();
        const gitProps = {
            owner,
            repo,
            issue_number,
        };

        try {
            const {data} = await githubClient.rest.issues.listLabelsOnIssue(gitProps);
            const issueLabels = data.map(({name}) => name);
            const labelsToRemove = git_labels.split(',').filter(label => issueLabels.includes(label));

            await Promise.all(labelsToRemove.map(name => githubClient.rest.issues.removeLabel({
                ...gitProps,
                name,
            })));
        } catch (err) {
            console.error("can't remove label: ", err && err.code);
        }
    }));
};
