const {SPRINT_STATUS} = require('../api/startrack/constants');

const {startrack} = require('../api');

/**
 * Функция поиска текущего спринта
 *
 * @param {string} boardId - идентификатор доски в трекере
 * @return {Promise<Object>}
 */
module.exports = async function getCurrentSprint(boardId) {
    const sprints = await startrack.getSprints(boardId);
    const currentSprint = sprints.find(({status}) => status === SPRINT_STATUS.IN_PROGRESS);

    if (!currentSprint) {
        throw new Error('There aren`t any sprints in progress');
    }

    return currentSprint;
};
