import {EActionType, EBlockType, ICarouselBlock} from '../../types/blocks';

export const carouselMocks: ICarouselBlock[] = [
    {
        type: EBlockType.CAROUSEL,
        title: 'Интересные места в городе',
        subtitle: 'Подборка от команды Путешествий',
        items: [
            {
                image: 'https://yastat.net/s3/travel-mail/mocks/peters%20fortress.png',
                title: 'Петропавловская крепость',
                url: 'https://afisha.yandex.ru',
                description: 'Место, откуда начался Санкт-Петербург',
                info: {
                    icon: 'https://yastat.net/s3/travel-mail/icons/Location.png',
                    text: '',
                },
            },
            {
                image: 'https://yastat.net/s3/travel-mail/mocks/five%20angles.png',
                title: 'Пять углов',
                url: 'https://afisha.yandex.ru',
                description:
                    'Пересечение пяти улиц 18 века, для тех, кто любит старину',
                info: {
                    icon: 'https://yastat.net/s3/travel-mail/icons/Location.png',
                    text: '1,2 км. от отеля',
                },
            },
            {
                image: 'https://yastat.net/s3/travel-mail/mocks/winter%20palace.png',
                title: 'Зимний дворец',
                url: 'https://afisha.yandex.ru',
                description:
                    'Дворец Екатерины II, с которого началась революция 1917 года',
                info: {
                    icon: 'https://yastat.net/s3/travel-mail/icons/Location.png',
                    text: '1,2 км. от отеля',
                },
            },
        ],
        action: {
            text: 'Посмотреть все места ',
            theme: EActionType.SECONDARY,
            url: 'https://afisha.yandex.ru',
        },
    },
    {
        type: EBlockType.CAROUSEL,
        title: 'Аудиогид по улицам и музеям',
        subtitle: 'Бесплатно для самостоятельных прогулок по городу',
        items: [
            {
                image: 'https://yastat.net/s3/travel-mail/mocks/spb-origin.png',
                title: 'Петербург Петра I: мечты vs реальность',
                url: 'https://afisha.yandex.ru',
                description: 'Пеший тур',
                info: {
                    icon: 'https://yastat.net/s3/travel-mail/icons/Time.png',
                    text: '45 минут',
                },
            },
            {
                image: 'https://yastat.net/s3/travel-mail/mocks/russian-museum.png',
                title: 'Русский музей. Михайловский дворец',
                url: 'https://afisha.yandex.ru',
                description: 'Пеший тур',
                info: {
                    icon: 'https://yastat.net/s3/travel-mail/icons/Time.png',
                    text: '',
                },
            },
            {
                image: 'https://yastat.net/s3/travel-mail/mocks/peters%20fortress.png',
                title: 'Прогулка по центру Петер- бурга от Думы...',
                url: 'https://afisha.yandex.ru',
                description: 'Велосипедный тур',
                info: {
                    icon: 'https://yastat.net/s3/travel-mail/icons/Time.png',
                    text: '1 час',
                },
            },
        ],
        action: {
            text: 'Посмотреть все аудиогиды',
            theme: EActionType.SECONDARY,
            url: 'https://afisha.yandex.ru',
        },
    },
    {
        type: EBlockType.CAROUSEL,
        title: 'Афиша на ваши даты',
        subtitle: 'Развлечения Санкт-Петербурга — что посмотреть и послушать',
        items: [
            {
                image: 'https://yastat.net/s3/travel-mail/mocks/crauze.png',
                title: 'Семейка Краузе',
                url: 'https://afisha.yandex.ru',
                description: 'От 1 000 ₽&nbsp;· Спектакль&nbsp;· 12+',
                info: {
                    icon: 'https://yastat.net/s3/travel-mail/icons/Calendar.png',
                    text: '21 ноября в 19:00',
                },
            },
            {
                image: 'https://yastat.net/s3/travel-mail/mocks/nothing-but-thieves.png',
                title: 'Nothing But Thieves',
                url: 'https://afisha.yandex.ru',
                description:
                    'От 2 500 ₽&nbsp;· Концерт&nbsp;· Рок&nbsp;· Альтернатива',
                info: {
                    icon: 'https://yastat.net/s3/travel-mail/icons/Calendar.png',
                    text: '21 ноября в 19:00',
                },
            },
            {
                image: 'https://yastat.net/s3/travel-mail/mocks/the-neighbourhood.png',
                title: 'The Neighbourhood',
                url: 'https://afisha.yandex.ru',
                description: 'От 1 000 ₽&nbsp;· Концерт&nbsp;· Альтернатива',
                info: {
                    icon: 'https://yastat.net/s3/travel-mail/icons/Calendar.png',
                    text: '',
                },
            },
        ],
        action: {
            text: 'Посмотреть все мероприятия',
            theme: EActionType.SECONDARY,
            url: 'https://afisha.yandex.ru',
        },
    },
    {
        type: EBlockType.CAROUSEL,
        title: 'Не забудьте забронировать отель',
        subtitle: 'Подборка предложений отелей Санкт-Петербурга',
        items: [
            {
                title: 'Санкт-Петербург',
                stars: 4,
                image: 'https://yastat.net/s3/travel-mail/mocks/spb-1.png',
                url: 'https://travel.yandex.ru/hotels',
                rating: 4.8,
                accommodation: 'аппартаменты',
                reviews: '123 отзыва',
                orderInfo: ['Бесплатная отмена', 'Промокод на такси'],
                price: 'от 5 200 ₽',
            },
            {
                title: 'Ритц Карлтон Москва',
                stars: 5,
                image: 'https://yastat.net/s3/travel-mail/mocks/ritz.png',
                url: 'https://travel.yandex.ru/hotels',
                rating: 3.9,
                accommodation: 'гостинница',
                reviews: '56 отзывов',
                orderInfo: ['Бесплатная отмена', 'Включен завтрак'],
                price: 'от 7 150 ₽',
            },
            {
                title: 'Ночлежка',
                image: 'https://yastat.net/s3/travel-mail/mocks/spb-2.png',
                url: 'https://travel.yandex.ru/hotels',
                rating: 2.5,
                accommodation: 'гостинница',
                reviews: '453 отзыва',
                orderInfo: [],
                price: 'от 6 600 ₽',
            },
        ],
        action: {
            text: 'Посмотреть все места ',
            theme: EActionType.PRIMARY,
            url: 'https://travel.yandex.ru/hotels',
        },
    },
];
