import {
    EActionType,
    ICarouselBlock,
    isCarouselBlockItem,
    isCarouselHotelItem,
} from '../../types/blocks';

import {rawHeader} from '../../components/rawHeader/rawHeader';

import {
    getCarouselHotelItemFeaturesRows,
    getCarouselHotelItemInfoRows,
    getCarouselHotelItemTitleRows,
    hotelItem,
} from './hotelItem';
import {
    carouselItem,
    getCarouselItemDescriptionRows,
    getCarouselItemTitleRows,
} from './carouselItem';

export default function carousel(block: ICarouselBlock): string {
    const {action} = block;
    const items = block.items
        .map((item, index) => {
            const isLast = index === block.items.length - 1;

            if (isCarouselBlockItem(item)) {
                const carouselItems = block.items.filter(isCarouselBlockItem);

                return carouselItem(item, {
                    isLast,
                    withInfo: carouselItems.some(({info}) => info.text),
                    rows: {
                        title: getCarouselItemTitleRows(carouselItems),
                        description:
                            getCarouselItemDescriptionRows(carouselItems),
                    },
                });
            }

            if (isCarouselHotelItem(item)) {
                const hotelItems = block.items.filter(isCarouselHotelItem);

                return hotelItem(item, isLast, {
                    title: getCarouselHotelItemTitleRows(hotelItems),
                    info: getCarouselHotelItemInfoRows(hotelItems),
                    features: getCarouselHotelItemFeaturesRows(hotelItems),
                });
            }

            return '';
        })
        .join('\n');

    return `
        <mj-wrapper mj-class="card" css-class="card">
            ${rawHeader(block)}

            <mj-section padding="0 4px">
                ${items}
            </mj-section>

            <mj-section text-align="left">
                <mj-column>
                    <mj-button
                        css-class="link-btn"
                        mj-class="btn ${
                            action.theme === EActionType.PRIMARY
                                ? 'btn-primary'
                                : 'btn-secondary'
                        }"
                        href="${action.url}"
                    >
                        ${action.text}
                    </mj-button>
                </mj-column>
            </mj-section>
        </mj-wrapper>
    `;
}
