import {ICarouselBlockHotelItem} from '../../types/blocks';

import {getRatingColor} from './utilities/getRatingColor';

// Костыль ддля выравнивания высоты колонок, т.к. в универсальной верстке это
// не достижимо, а из-за ограничения на размер письма мы не можем делать 2 разные
// верстки для тача и десктопа (они обе присутствовали бы в письме, но в зависимости
// от типа устройства показывалась либо одна вёрстка, либо другая)
const AVERAGE_TITLE_SYMBOLS_IN_ROW = 15;
const TITLE_ROW_HEIGHT = 22;
const AVERAGE_INFO_SYMBOLS_IN_ROW = 22;
const INFO_ROW_HEIGHT = 20;
const FEATURES_ROW_HEIGHT = 20;

const replaceSymbols = (str: string): string => str.replace(/&\w+;/g, '.');
const getHotelTitle = (item: ICarouselBlockHotelItem): string =>
    `${item.title}${item.stars ? `&nbsp;${item.stars}*` : ''}`;
const getHotelInfo = (item: ICarouselBlockHotelItem): string =>
    `${[item.reviews, item.accommodation].filter(Boolean).join('&nbsp;· ')}`;

export const getCarouselHotelItemTitleRows = (
    items: ICarouselBlockHotelItem[],
): number =>
    Math.ceil(
        items.reduce(
            (length, item) => Math.max(length, getHotelTitle(item).length),
            0,
        ) / AVERAGE_TITLE_SYMBOLS_IN_ROW,
    );

export const getCarouselHotelItemInfoRows = (
    items: ICarouselBlockHotelItem[],
): number =>
    Math.ceil(
        items.reduce(
            (length, item) =>
                Math.max(length, replaceSymbols(getHotelInfo(item)).length),
            0,
        ) / AVERAGE_INFO_SYMBOLS_IN_ROW,
    );

export const getCarouselHotelItemFeaturesRows = (
    items: ICarouselBlockHotelItem[],
): number =>
    items.reduce((count, item) => Math.max(count, item.orderInfo.length), 0);

export function hotelItem(
    item: ICarouselBlockHotelItem,
    isLast: boolean,
    rows: {
        title: number;
        info: number;
        features: number;
    },
): string {
    return `
        <mj-column
            css-class="rounded ${isLast ? 'desktop_only' : ''}"
            width="33.333%"
            padding="0 6px 20px"
            inner-border-top="none"
        >
            <mj-button
                href="${item.url}"
                target="_blank"
                rel="noopener noreferrer"
                padding="0"
                inner-padding="0"
                background-color="#fff"
            >
                <table cellspacing="0" cellpadding="0" style="color: #000;">
                    <tr>
                        <td>
                            <img
                                class="carousel_image"
                                src="${item.image}"
                                width="202px"
                                style="display: block; border-radius: 8px 8px 0 0; background-color: #e6e6e6;"
                            />
                        </td>
                    </tr>

                    <tr>
                        <td
                            class="left-border right-border fluid-height"
                            style="height: ${
                                rows.title * TITLE_ROW_HEIGHT
                            }px; padding: 12px 16px 8px; vertical-align: top;"
                        >
                            <h3 style="margin: 0; font-size: 18px; line-height: 22px; font-weight: 700;">
                                ${getHotelTitle(item)}
                            </h3>
                        </td>
                    </tr>

                    <tr>
                        <td
                            class="left-border right-border fluid-height"
                            style="height: ${
                                rows.info * INFO_ROW_HEIGHT
                            }px; padding: 0 16px; vertical-align: top; font-size: 15px; line-height: 20px;"
                        >
                            <span style="font-weight: 500; color: #fff; background-color: ${getRatingColor(
                                item.rating,
                            )}; border-radius: 3px; padding: 2px 3px;">${
        item.rating
    }</span>
                            ${[item.reviews, item.accommodation].join(' · ')}
                        </td>
                    </tr>

                    <tr>
                        <td
                            class="left-border right-border fluid-height"
                            style="height: ${
                                rows.features * FEATURES_ROW_HEIGHT
                            }px; padding: 8px 16px 0; vertical-align: top; color: #090; font-size: 15px; line-height: 20px;"
                        >
                            ${item.orderInfo
                                .map((info) => `<div>&bull; ${info}</div>`)
                                .join('\n')}
                        </td>
                    </tr>

                    <tr>
                        <td
                            class="left-border right-border bottom-border bottom-border-rounded fluid-height"
                            style="padding: 12px 16px 16px; font-size: 22px; line-height: 26px; font-weight: 700; object-fit: cover;"
                        >
                            ${item.price}
                        </td>
                    </tr>
                </table>
            </mj-button>
        </mj-column>
    `;
}
