import {IDisclaimersBlock} from '../../types/blocks';

const URL_REGEXP = /(https?:\/\/[\w./]+)/g;

export default function disclaimers(block: IDisclaimersBlock): string {
    return `
        <mj-wrapper padding-top="18px" padding-bottom="0">
            <mj-section>
                <mj-column>
                    <mj-text
                        mj-class="text-secondary-color"
                        line-height="20px"
                        font-size="15px"
                    >
                        ${block.disclaimers
                            .map(
                                (disclaimer) => `
                            <p>
                                ${disclaimer.replace(
                                    URL_REGEXP,
                                    (match) =>
                                        `<a target="_blank" rel="nofollow noopener noreferrer" class="link" href="${match}">${match}</a>`,
                                )}
                            </p>
                        `,
                            )
                            .join('\n')}
                    </mj-text>
                </mj-column>
            </mj-section>
        </mj-wrapper>
    `;
}
