import {IFooterBlock} from '../../types/blocks';

export default function header(block: IFooterBlock): string {
    const {
        support: {phoneNumber, hint},
    } = block;

    return `
        <mj-wrapper padding-top="18px" padding-bottom="0">
            <mj-section>
                <mj-column padding-bottom="12px" padding-left="6px">
                    <mj-social icon-size="32px" mode="horizontal" align="left">
                        ${block.social
                            .map(
                                (item) => `
                            <mj-social-element
                                href="${item.url}"
                                src="${item.image}"
                            />`,
                            )
                            .join('\n')}
                    </mj-social>
                </mj-column>

                <mj-column css-class="mobile_left_aligned" padding-bottom="12px">
                    <mj-text font-size="15px" line-height="40px" align="right">
                        <a href="tel:${phoneNumber}" style="text-decoration: none; color: #000;">
                            ${hint}<b class="footer__phone">${phoneNumber}</b>
                        </a>
                    </mj-text>
                </mj-column>
            </mj-section>

            <mj-section>
                <mj-column>
                    <mj-text mj-class="link" font-size="15px" line-height="20px">
                        <span style="color: #333">&copy; 2009–${new Date().getFullYear()}</span>
                        &nbsp;&nbsp;
                        ${block.links
                            .map(
                                ({url, text}) => `
                            <a class="link" style="padding-right: 12px;" href="${url}">${text}</a>
                        `,
                            )
                            .join('\n')}
                    </mj-text>
                </mj-column>
            </mj-section>
        </mj-wrapper>
    `;
}
