import {IGreetingBlock} from '../../types/blocks';

export default function greeting(block: IGreetingBlock): string {
    if (block.overlaying) {
        return `
            <mj-wrapper mj-class="card" css-class="card" padding="0">
                <mj-section css-class="desktop_only" padding="0">
                    <mj-column vertical-align="middle" padding="0">
                        <mj-image
                            src="${block.image}"
                            border-radius="20px 0 0 20px"
                            height="443px"
                            padding="0"
                        />
                    </mj-column>

                    <mj-column vertical-align="middle" padding="0 30px">
                        <mj-text
                            css-class="greeting__title"
                            font-weight="700"
                            padding-bottom="8px"
                        >
                            ${block.title}
                        </mj-text>
                        <mj-text css-class="greeting__text">
                            ${block.text
                                .split('\n')
                                .map(textPart => `<p>${textPart}</p>`)
                                .join('\n')}
                        </mj-text>
                    </mj-column>
                </mj-section>

                <mj-hero
                    css-class="mobile_only hero_card"
                    mode="fixed-height"
                    height="482px"
                    background-height="482px"
                    background-url="${block.image}"
                >
                    <mj-text
                        css-class="greeting__title"
                        font-weight="700"
                        padding="28px 22px 0"
                    >
                        ${block.title}
                    </mj-text>
                    <mj-text css-class="greeting__text" padding="0 22px">
                        ${block.text
                            .split('\n')
                            .map(textPart => `<p>${textPart}</p>`)
                            .join('\n')}
                    </mj-text>
                </mj-hero>
            </mj-wrapper>
        `;
    }

    return `
        <mj-wrapper mj-class="card" css-class="card" padding-bottom="7px">
            <mj-section padding-bottom="22px">
                <mj-column>
                    <mj-image border-radius="8px" src="${block.image}"/>
                </mj-column>
            </mj-section>

            <mj-section>
                <mj-column>
                    <mj-text css-class="greeting__title" font-weight="700">
                        ${block.title}
                    </mj-text>

                    <mj-text css-class="greeting__text">
                        ${block.text
                            .split('\n')
                            .map(textPart => `<p>${textPart}</p>`)
                            .join('\n')}
                    </mj-text>
                </mj-column>
            </mj-section>
        </mj-wrapper>
    `;
}
