import {IHeaderBlock} from '../../types/blocks';

const SEPARATOR = '<span style="color: #999; padding: 0 6px;">&bull;</span>';

export default function header(block: IHeaderBlock): string {
    return `
        <mj-wrapper padding="0 0 20px">
            <mj-section>
                <mj-column>
                    <mj-image
                        align="left"
                        width="258px"
                        css-class="travelLogo"
                        src="${block.logo.image || block.logo}"
                        alt="travel logo"
                        href="${block.logo.url || 'https://travel.yandex.ru'}"
                    />
                </mj-column>
            </mj-section>

            ${
                block.links.length
                    ? `
                <mj-section padding-top="8px">
                    <mj-column>
                        <mj-text mj-class="link" font-size="15px" line-height="20px">
                            ${block.links
                                .map(
                                    (link, index) => `
                                <span style="white-space: nowrap">
                                    <a class="link" target="_blank" href="${
                                        link.url
                                    }">${link.text}</a>
                                    ${
                                        index < block.links.length - 1
                                            ? SEPARATOR
                                            : ''
                                    }
                                </span>`,
                                )
                                .join('\n')}
                        </mj-text>
                    </mj-column>
                </mj-section>
            `
                    : ''
            }
        </mj-wrapper>
    `;
}
