import {IBookingBlock} from '../../types/blocks';

import {orderButtons} from '../../components/orderButtons/orderButtons';
import {locationLink} from '../../components/locationLink/locationLink';
import {rawHeader} from '../../components/rawHeader/rawHeader';

export default function hotelsOrder(block: IBookingBlock): string {
    return `
        <mj-wrapper mj-class="card" css-class="card" padding-bottom="8px">
            ${rawHeader(block)}

            <mj-section>
                <mj-column width="69%" padding-bottom="20px">
                    <mj-text font-size="18px" line-height="22px" padding-bottom="10px">
                        ${block.hotelName}
                    </mj-text>

                    <mj-text mj-class="link" font-size="15px" line-height="20px" padding-bottom="10px">
                        ${locationLink(block.geoPosition)}
                    </mj-text>

                    <mj-text font-size="15px" line-height="20px">
                        ${block.dates}
                    </mj-text>

                    <mj-text font-size="15px" line-height="20px">
                        ${[block.checkin, block.checkout].join(', ')}
                    </mj-text>
                </mj-column>

                <mj-column width="31%" padding-bottom="20px">
                    <mj-image fluid-on-mobile="true" border-radius="8px" src="${
                        block.image
                    }" />
                </mj-column>
            </mj-section>

            ${orderButtons(block)}
        </mj-wrapper>
    `;
}
