import {IPreTripBlock} from '../../types/blocks';

import {rawHeader} from '../../components/rawHeader/rawHeader';

interface IPreTripBlockGroup {
    title: string;
    items: IPreTripBlockItem[];
}

interface IPreTripBlockItem {
    icon: string;
    description: string;
}

const getColumnItems = (
    items: IPreTripBlockItem[],
    column: number,
    columnsCount: number,
): IPreTripBlockItem[] =>
    items.filter((item, index) => index % columnsCount === column);

const renderColumn = (items: IPreTripBlockItem[]): string => `
    <mj-column>
        ${items
            .map(
                (item) => `
            <mj-table padding-bottom="16px">
                <tr>
                    <td style="line-height: normal; width: 50px; height: 50px; text-align: center;">
                        <img width="50" height="50" style="width: 50px; height: 50px;" src="${item.icon}" />
                    </td>
                    <td style="text-align: left; padding-left: 12px; font-size: 15px; line-height: 20px;">
                        ${item.description}
                    </td>
                </tr>
            </mj-table>
        `,
            )
            .join('\n')}
    </mj-column>
`;

const renderBlock = (
    block: IPreTripBlockGroup,
    index: number,
    blocks: IPreTripBlockGroup[],
): string => `
    <mj-section>
        <mj-column>
            <mj-text font-size="18px" line-height="22px" font-weight="500" padding-bottom="20px">
                ${block.title}
            </mj-text>
        </mj-column>
    </mj-section>

    <mj-section padding-bottom="${index < blocks.length - 1 ? '16px' : '12px'}">
        ${renderColumn(getColumnItems(block.items, 0, 3))}
        ${renderColumn(getColumnItems(block.items, 1, 3))}
        ${renderColumn(getColumnItems(block.items, 2, 3))}
    </mj-section>
`;

export default function preTrip(block: IPreTripBlock): string {
    return `
        <mj-wrapper mj-class="card" css-class="card">
            ${rawHeader(block)}

            ${block.blocks.map(renderBlock).join('\n')}

            <mj-section>
                <mj-column>
                    <mj-text font-size="15px" line-height="20px">
                        ${block.partingWishes}
                    </mj-text>
                </mj-column>
            </mj-section>
        </mj-wrapper>
    `;
}
