export default function styles(): string {
    return `
        <mj-style inline="inline">
            .mobile_only {
                display: none!important;
            }

            .container {
                padding: 24px 8px;
                margin: auto;
                min-width: 688px;
                box-sizing: border-box;
            }

            .container > div > table { width: 672px!important;}

            .hero_card > table {
                border-radius: 20px;
                overflow: hidden;
            }

            .rounded > table table {
                border-collapse:separate; border-radius:8px;
            }

            .card {
                margin-bottom: 12px!important;
            }

            .link {
                text-decoration: none;
                color: #667AE0;
            }

            .list {
                margin: 0;
                padding-inline-start: 16px;
            }

            .link-btn a {
                width: 100%;
                box-sizing: border-box;
            }

            .btn-icon {
                vertical-align: text-bottom;
            }

            .left-border {
                border-left: 2px solid #e6e6e6;
            }

            .right-border {
                border-right: 2px solid #e6e6e6;
            }

            .bottom-border {
                border-bottom: 2px solid #e6e6e6;
            }

            .top-border {
                border-top: 2px solid #e6e6e6;
            }

            .bottom-border-rounded {
                border-radius: 0 0 8px 8px;
            }
        </mj-style>

        <mj-style>
            @media only screen and (min-width:100px) {
                .container.container {
                    min-width: 0!important;
                }
            }
        </mj-style>

        <mj-style>
            @media only screen {
                .button:hover .link,
                .link:hover {
                    color: #d00!important;
                }
            }
        </mj-style>

        <mj-style>
            @media only screen and (min-width:480px) {
                .travelLogo td {
                    width: 258px!important;
                }
            }
        </mj-style>

        <mj-style>
            @media only screen and (max-width:479px) {
                .container > div > table {
                    width: 100%!important;
                    max-width: 100%!important;
                }

                .travelLogo td {
                    width: 213px !important;
                }

                .link-btn > table {
                    width: 100%;
                }

                .mobile_left_aligned td div {
                    text-align: left!important;
                }

                .mobile_block_element {
                    display: block;
                    margin-bottom: 4px;
                }

                .desktop_only {
                    display: none!important;
                }

                .mobile_only {
                    display: block!important;
                }

                .fluid-height {
                    height: auto!important;
                }

                .collapseBottomPadding {
                    padding-bottom: 0!important;
                }
            }
        </mj-style>

        <!-- GREETING BLOCK --->

        <!-- common styles -->
        <mj-style inline="inline">
            .greeting__title div {
                font-size: 32px!important;
                line-height: 38px!important;
            }

            .greeting__text div {
                font-size: 15px!important;
                line-height: 20px!important;
            }
        </mj-style>

        <!-- mobile styles -->
        <mj-style>
            @media only screen and (max-width:479px) {
                .greeting__title div  {
                    font-size: 22px!important;
                    line-height: 26px!important;
                }
            }
        </mj-style>

        <!-- CAROUSEL -->

        <mj-style inline="inline">
            .carousel_image {
                height: 125px!important;
            }
        </mj-style>

        <mj-style>
            @media only screen and (max-width:479px) {
                .carousel_image {
                    width: 100%!important;
                    height: auto!important;
                    max-height: 160px;
                }
            }
        </mj-style>

        <!-- TRAIN ORDER -->

        <!-- common styles -->
        <mj-style inline="inline">
            .trainsOrder__time {
                font-size: 22px;
                line-height: 26px;
                font-weight: 700;
                white-space: nowrap;
                width: 67px;
            }

            .trainsOrder__duration {
                text-align: center;
                font-size: 15px;
                line-height: 20px;
            }

            .trainsOrder__divider {
                border: none;
                height: 1px;
                background-color: #e6e6e6;
            }

            .trainsOrder__station {
                font-size: 15px;
                line-height: 20px;
                vertical-align: top;
            }
        </mj-style>

        <!-- FOOTER -->

        <!-- mobile styles -->
        <mj-style>
            @media only screen and (max-width:479px) {
                .footer__phone {
                    font-weight: normal;
                    color: #667AE0;
                }
            }
        </mj-style>

        <!--- Костыль для изменения подхода с mobile-first на desktop-first --->

        <mj-style inline="inline">
            .mj-column-per-100 { width:100%; max-width: 100%; }
            .mj-column-per-50 { width:50%; max-width: 50%; }
            .mj-column-per-33-333 { width:33.333%; max-width: 33.333%; }
            .mj-column-per-69 { width:69%; max-width: 69%; }
            .mj-column-per-31 { width:31%; max-width: 31%; }
            .mj-column-per-35 { width:35%; max-width: 35%; }
            .mj-column-per-75 { width:75%; max-width: 75%; }
            .mj-column-per-45 { width:45%; max-width: 45%; }
            .mj-column-per-33-333333333333336 { width:33.333333333333336%!important; max-width: 33.333333333333336%; }
        </mj-style>

        <mj-style>
            @media only screen and (max-width:479px) {
                .mj-column-per-100,
                .mj-column-per-50,
                .mj-column-per-33-333,
                .mj-column-per-69,
                .mj-column-per-31,
                .mj-column-per-35,
                .mj-column-per-75,
                .mj-column-per-45,
                .mj-column-per-33-333333333333336 {
                    width: 100%!important;
                    max-width: 100%!important;
                }

                .mj-column-per-50 .mj-column-per-100 { width:100%!important; max-width: 100%!important; }
                .mj-column-per-50 .mj-column-per-50 { width:50%!important; max-width: 50%!important; }
                .mj-column-per-50 .mj-column-per-33-333 { width:33.333%!important; max-width: 33.333%!important; }
                .mj-column-per-50 .mj-column-per-69 { width:69%!important; max-width: 69%!important; }
                .mj-column-per-50 .mj-column-per-31 { width:31%!important; max-width: 31%!important; }
                .mj-column-per-50 .mj-column-per-35 { width:35%!important; max-width: 35%!important; }
                .mj-column-per-50 .mj-column-per-75 { width:75%!important; max-width: 75%!important; }
                .mj-column-per-50 .mj-column-per-45 { width:45%!important; max-width: 45%!important; }
                .mj-column-per-50 .mj-column-per-33-333333333333336 { width:33.333333333333336%!important; max-width: 33.333333333333336%!important; }
            }
        </mj-style>
    `;
}
