import {ITrainTicketBlock} from '../../types/blocks';

import {orderButtons} from '../../components/orderButtons/orderButtons';
import {locationLink} from '../../components/locationLink/locationLink';
import {rawHeader} from '../../components/rawHeader/rawHeader';

export default function trainsOrder(block: ITrainTicketBlock): string {
    const {departure, arrival} = block;

    return `
        <mj-wrapper mj-class="card" css-class="card" padding="20px 14px 8px">
            ${rawHeader(block)}

            <mj-section>
                <mj-column padding="0 6px">
                    <mj-text font-size="18px" line-height="22px">
                        <b>${block.points.join('&nbsp;— ')}</b>
                        <span>${block.departure.date}</span>
                    </mj-text>
                    <mj-text font-size="15px" line-height="20px">
                        ${block.boardingHint}
                    </mj-text>
                </mj-column>
            </mj-section>

            <mj-section padding="12px 0 20px">
                <mj-column padding="0 6px" width="75%">
                    <mj-table padding="0">
                        <tr>
                            <td colspan="2">${departure.nextDateHint}</td>
                            <td colspan="2" style="text-align: right;">${
                                arrival.nextDateHint
                            }</td>
                        </tr>
                        <tr>
                            <td class="trainsOrder__time">${departure.time}</td>
                            <td colspan="2" class="trainsOrder__duration">
                                <table style="width: 100%; vertical-align: middle;">
                                    <tbody>
                                        <tr>
                                            <td style="padding-right: 8px;">
                                                <hr class="trainsOrder__divider" />
                                            </td>
                                            <td style="width: 20%; white-space: nowrap!important;">
                                                ${block.duration}
                                            </td>
                                            <td style="padding-left: 8px;">
                                                <hr class="trainsOrder__divider" />
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </td>
                            <td class="trainsOrder__time" style="text-align: right;">${
                                arrival.time
                            }</td>
                        </tr>
                        <tr>
                            <td colspan="2" class="trainsOrder__station">
                                ${departure.station}
                            </td>
                            <td colspan="2" class="trainsOrder__station" style="text-align: right;">
                                ${arrival.station}
                            </td>
                        </tr>
                    </mj-table>
                </mj-column>
            </mj-section>

            <mj-section padding-bottom="20px">
                <mj-column padding="0 6px">
                    <mj-text font-size="15px" line-height="20px">
                        <span class="mobile_block_element" style="color: #c60; padding-right: 16px;">
                            ${block.trainName}
                        </span>
                        <span class="mobile_block_element" style="padding-right: 16px;">
                            ${block.trainInfo}
                        </span>
                        <span class="mobile_block_element" style="white-space: nowrap;">
                            ${block.facilities
                                .map(
                                    (facility) => `
                                <img
                                    src="${facility.icon}"
                                    alt="${facility.hint}"
                                    height="16"
                                    width="16"
                                    style="height: 16px; width: 16px; vertical-align: text-bottom;"
                                />
                            `,
                                )
                                .join('&nbsp;')}
                        </span>
                    </mj-text>
                </mj-column>
            </mj-section>

            ${orderButtons(block)}

            <mj-section>
                <mj-column padding="0 6px">
                    <mj-divider padding="8px 0 20px" border-width="1px" border-color="#e6e6e6"/>
                </mj-column>
            </mj-section>

            <mj-section>
                ${
                    block.route?.url
                        ? `<mj-column width="50%" padding="0 6px 12px">
                        <mj-text mj-class="link">
                            ${locationLink(block.route)}
                        </mj-text>
                    </mj-column>`
                        : ''
                }

                <mj-column ${
                    block.route?.url ? 'width="45%"' : ''
                } padding="0 6px 12px">
                    <mj-text>
                        <img
                            class="btn-icon btn-icon-left"
                            width="16"
                            height="16"
                            style="width: 16px; height: 16px;"
                            src="https://yastat.net/s3/travel-mail/icons/Info.png"
                        /> &nbsp;${block.orderNumber}
                    </mj-text>
                </mj-column>
            </mj-section>
        </mj-wrapper>
    `;
}
