import {IUsefulBlock} from '../../types/blocks';

import {rawHeader} from '../../components/rawHeader/rawHeader';

export default function useful(block: IUsefulBlock): string {
    const items = block.items
        ? `
            <mj-section padding-bottom="0">
                ${block.items
                    .map(
                        (item) => `
                    <mj-column padding-bottom="16px">
                        <mj-button
                            css-class="button"
                            align="left"
                            text-align="left"
                            padding="0"
                            inner-padding="0"
                            background-color="#fff"
                            href="${item.url}"
                            width="100%"
                        >
                            <table cellpadding="0" cellspacing="0">
                                <tr style="vertical-align: top; line-height: normal;">
                                    <td style="width: 64px;">
                                        <img src="${item.image}" height="50" width="50">
                                    </td>
                                    <td>
                                        <p class="link" style="margin: 0 0 4px; font-size: 18px; font-weight: 500; line-height: 22px; color: #667AE0;">
                                            ${item.title}
                                        </p>

                                        <p style="margin: 0; font-size: 15px; line-height: 20px; color: #000;">
                                            ${item.description}
                                        </p>
                                    </td>
                                </tr>
                            </table>
                        </mj-button>
                    </mj-column>
                `,
                    )
                    .join('\n')}
            </mj-section>
        `
        : '';

    return `
        <mj-wrapper mj-class="card" css-class="card" padding-bottom="8px">
            ${rawHeader(block)}

            ${items}
        </mj-wrapper>
    `;
}
