import {EActionType, EBlockType, IWeatherBlock} from '../../types/blocks';

export const weatherMocks: IWeatherBlock[] = [
    {
        type: EBlockType.WEATHER,
        title: 'Погода на ваши даты',
        items: [
            {
                day: 'Пн',
                isWeekend: false,
                date: '18 ноя',
                temperature: {
                    day: 'днём +8',
                    night: 'ночью -2',
                },
                conditions: {
                    icon: 'https://yastat.net/s3/travel-mail/icons/weather/Sunny.png',
                    description: 'Ясно',
                },
            },
            {
                day: 'Вт',
                isWeekend: false,
                date: '19 ноя',
                temperature: {
                    day: '+12',
                    night: '+4',
                },
                conditions: {
                    icon: 'https://yastat.net/s3/travel-mail/icons/weather/Sunny.png',
                    description: 'Ясно',
                },
            },
            {
                day: 'Ср',
                isWeekend: false,
                date: '20 ноя',
                temperature: {
                    day: '+7',
                    night: '-1',
                },
                conditions: {
                    icon: 'https://yastat.net/s3/travel-mail/icons/weather/Cloudy.png',
                    description: 'Облачно',
                },
            },
            {
                day: 'Чт',
                isWeekend: false,
                date: '21 ноя',
                temperature: {
                    day: '+8',
                    night: '0',
                },
                conditions: {
                    icon: 'https://yastat.net/s3/travel-mail/icons/weather/Cloudy.png',
                    description: 'Облачно',
                },
            },
            {
                day: 'Пт',
                isWeekend: false,
                date: '22 ноя',
                temperature: {
                    day: '+6',
                    night: '+1',
                },
                conditions: {
                    icon: 'https://yastat.net/s3/travel-mail/icons/weather/Rainy.png',
                    description: 'Пасмурно',
                },
            },
            {
                day: 'Сб',
                isWeekend: true,
                date: '23 ноя',
                temperature: {
                    day: '+7',
                    night: '+1',
                },
                conditions: {
                    icon: 'https://yastat.net/s3/travel-mail/icons/weather/Rainy.png',
                    description: 'Пасмурно',
                },
            },
            {
                day: 'Вс',
                isWeekend: true,
                date: '24 ноя',
                temperature: {
                    day: '+6',
                    night: '-1',
                },
                conditions: {
                    icon: 'https://yastat.net/s3/travel-mail/icons/weather/Rainy.png',
                    description: 'Пасмурно',
                },
            },
        ],
        action: {
            text: 'Подробный прогноз на 10 дней',
            url: '#',
            theme: EActionType.SECONDARY,
        },
    },
];
