import {
    EActionType,
    IWeatherBlock,
    IWeatherBlockItem,
} from '../../types/blocks';

import {rawHeader} from '../../components/rawHeader/rawHeader';

const weatherGroup = (items: IWeatherBlockItem[]): string =>
    items
        .map(
            ({day, isWeekend, date, conditions, temperature}) => `
        <mj-column padding-bottom="20px">
            <mj-text font-size="15px" line-height="20px" ${
                isWeekend ? 'color="#E31740"' : ''
            }>${day}</mj-text>
            <mj-text mj-class="text-secondary-color" padding-bottom="4px">${date}</mj-text>
            <mj-image padding-bottom="4px" align="left" height="48px" width="48px" src="${
                conditions.icon
            }"/>
            <mj-text font-size="15px" line-height="20px" font-weight="700">${
                temperature.day
            }</mj-text>
            <mj-text padding-bottom="8px">${temperature.night}</mj-text>
            <mj-text mj-class="text-secondary-color">${
                conditions.description
            }</mj-text>
        </mj-column>
    `,
        )
        .join('\n');

export default function weather(block: IWeatherBlock): string {
    return `
        <mj-wrapper mj-class="card" css-class="card">
            ${rawHeader(block)}

            <mj-section>
                <mj-group>
                    ${weatherGroup(block.items.slice(0, 3))}
                </mj-group>

                <mj-group>
                    ${weatherGroup(block.items.slice(3, 6))}
                </mj-group>
            </mj-section>

            <mj-section>
                <mj-column>
                    <mj-button
                        css-class="link-btn"
                        mj-class="btn ${
                            block.action.theme === EActionType.PRIMARY
                                ? 'btn-primary'
                                : 'btn-secondary'
                        }"
                        href="${block.action.url}"
                    >${block.action.text}</mj-button>
                </mj-column>
            </mj-section>
        </mj-wrapper>
    `;
}
