import {EActionType, IButtonLink} from '../../types/blocks';

export function buttonLink(
    {theme, url, text}: IButtonLink,
    icon?: string,
): string {
    return `
        <mj-button
            width="100%"
            css-class="link-btn"
            mj-class="btn ${
                theme === EActionType.PRIMARY ? 'btn-primary' : 'btn-secondary'
            }"
            href="${url}"
        >
            ${
                icon
                    ? `<img
                        class="btn-icon"
                        src="${icon}"
                        width="16"
                        height="16"
                        style="width: 16px; height: 16px;"
                   /> &nbsp;${text}`
                    : text
            }
        </mj-button>
    `;
}
