import {ILink} from '../../types/blocks';

export function locationLink({url, text}: ILink): string {
    return `
        <a
            class="link"
            href="${url}"
            target="_blank"
            rel="noopener noreferrer"
            style="color: #667AE0; text-decoration: none;"
        >
            <img
                class="btn-icon"
                width="16"
                height="16"
                style="width: 16px; height: 16px;"
                src="https://yastat.net/s3/travel-mail/icons/LocationBlue.png"
            /> &nbsp;${text}
        </a>
    `;
}
