export function rawHeader({
    title,
    subtitle,
}: {
    title: string;
    subtitle?: string;
}): string {
    return `
        <mj-raw>
            <table border="0" cellpadding="0" cellspacing="0" role="presentation" width="100%" style="font-family:Helvetica,Arial,sans-serif; color:#000; text-align: left; margin-bottom: 20px;">
                <tbody>
                    <tr><td style="font-size:22px;font-weight:700;line-height:26px; padding: 0 10px;">${title}</td></tr>
                    ${
                        subtitle
                            ? `<tr><td style="font-size:15px;line-height:20px; padding: 4px 10px 0;">${subtitle}</td></tr>`
                            : ''
                    }
                </tbody>
            </table>
        </mj-raw>
    `;
}
