import {Request, Response} from '@yandex-data-ui/core/build/types';
import {TEmailBlock} from '../types/blocks';

import renderer from '../services/renderer/renderer';

export default (req: Request, res: Response, blocks: TEmailBlock[]): void => {
    if (!blocks || !blocks.length) {
        res.sendStatus(400);
    } else {
        console.time('email');

        const mail = renderer(blocks);

        console.timeEnd('email');
        console.log(JSON.stringify(blocks));

        if (mail.errors.length) {
            req.utils.logError('Render is failed', undefined, {
                input: blocks,
                output: mail.errors,
            });
            res.sendStatus(500);
        } else {
            res.send(mail.html);
        }
    }
};
