import {Request, Response} from '@yandex-data-ui/core/build/types';
import {TEmailBlock} from '../types/blocks';

import {prepareStructuredAnswer} from './utilities/prepareStructuredAnswer';

import renderer from '../services/renderer/renderer';

export default (req: Request, res: Response): void => {
    const blocks = req.body as TEmailBlock[];

    if (!blocks || !blocks.length) {
        res.sendStatus(400);
    } else {
        console.time('email');

        const mail = renderer(blocks);

        console.timeEnd('email');
        console.log(JSON.stringify(blocks));

        if (mail.errors.length) {
            req.utils.logError('Render is failed', undefined, {
                input: blocks,
                output: mail.errors,
            });
            res.sendStatus(500);
        } else {
            res.json(prepareStructuredAnswer(mail.html));
        }
    }
};
