const HEAD_REGEXP = /(?<=<head.*>)([^]*)(?=<\/head>)/;
const BODY_REGEXP = /(?<=<body.*>)([^]*)(?=<\/body>)/;

export function prepareStructuredAnswer(plainEmail: string): {
    head: string | null;
    body: string | null;
} {
    const parsedHead = HEAD_REGEXP.exec(plainEmail);
    const parsedBody = BODY_REGEXP.exec(plainEmail);

    return {
        head: parsedHead && parsedHead[0],
        body: parsedBody && parsedBody[0],
    };
}
