import mjml2html from 'mjml';

import {TEmailBlock} from '../../types/blocks';
import {IMJMLParseResults} from '../../types/mjml';

import mapBlockToComponent from './utilities/mapBlockToComponent';

import styles from '../../blocks/styles/styles';
import attributes from '../../blocks/attributes/attributes';

export default function renderer(blocks: TEmailBlock[]): IMJMLParseResults {
    return mjml2html(
        `
        <mjml>
            <mj-head>
                ${styles()}
                ${attributes()}
            </mj-head>
            <mj-body
                css-class="container"
                background-color="#F2F3F6"
                width="672px"
            >
                ${blocks.map((item) => mapBlockToComponent(item))}
            </mj-body>
        </mjml>
    `,
        {
            minify: true,
            minifyOptions: {
                collapseWhitespace: true,
                removeEmptyAttributes: true,
            },
        },
    );
}
