import {
    isFooterBlock,
    isGreetingBlock,
    isHeaderBlock,
    isUsefulBlock,
    isCarouselBlock,
    TEmailBlock,
    isTrainTicketBlock,
    isWeatherBlock,
    isPreTripBlock,
    isBookingBlock,
    isDisclaimersBlock,
} from '../../../types/blocks';

import header from '../../../blocks/header/header';
import greeting from '../../../blocks/greeting/greeting';
import useful from '../../../blocks/useful/useful';
import carousel from '../../../blocks/carousel/carousel';
import trainsOrder from '../../../blocks/trainsOrder/trainsOrder';
import footer from '../../../blocks/footer/footer';
import weather from '../../../blocks/weather/weather';
import preTrip from '../../../blocks/preTrip/preTrip';
import hotelsOrder from '../../../blocks/hotelsOrder/hotelsOrder';
import disclaimers from '../../../blocks/disclaimers/disclaimers';

export default function mapBlockToComponent(block: TEmailBlock): string {
    if (isHeaderBlock(block)) {
        return header(block);
    }

    if (isGreetingBlock(block)) {
        return greeting(block);
    }

    if (isCarouselBlock(block)) {
        return carousel(block);
    }

    if (isUsefulBlock(block)) {
        return useful(block);
    }

    if (isBookingBlock(block)) {
        return hotelsOrder(block);
    }

    if (isTrainTicketBlock(block)) {
        return trainsOrder(block);
    }

    if (isWeatherBlock(block)) {
        return weather(block);
    }

    if (isPreTripBlock(block)) {
        return preTrip(block);
    }

    if (isFooterBlock(block)) {
        return footer(block);
    }

    if (isDisclaimersBlock(block)) {
        return disclaimers(block);
    }

    return '';
}
