export interface IMJMLParseError {
    line: number;
    message: string;
    tagName: string;
    formattedMessage: string;
}

export interface IMJMLParseResults {
    html: string;
    errors: IMJMLParseError[];
}

export enum EMJMLTag {
    // Base components
    // @see https://mjml.io/documentation/#components
    MJML = 'mjml',
    HEAD = 'mj-head',
    BODY = 'mj-body',
    INCLUDE = 'mj-include',

    // Head components
    // @see https://mjml.io/documentation/#standard-head-components
    ATTRIBUTES = 'mj-attributes',
    BREAKPOINT = 'mj-breakpoint',
    FONT = 'mj-font',
    PREVIEW = 'mj-preview',
    STYLE = 'mj-style',
    TITLE = 'mj-title',

    // Body components
    // @see https://mjml.io/documentation/#standard-body-components
    ACCORDION = 'mj-accordion',
    BUTTON = 'mj-button',
    CAROUSEL = 'mj-carousel',
    COLUMN = 'mj-column',
    DIVIDER = 'mj-divider',
    GROUP = 'mj-group',
    HERO = 'mj-hero',
    IMAGE = 'mj-image',
    NAVBAR = 'mj-navbar',
    RAW = 'mj-raw',
    SECTION = 'mj-section',
    SOCIAL = 'mj-social',
    SPACER = 'mj-spacer',
    TABLE = 'mj-table',
    TEXT = 'mj-text',
    WRAPPER = 'mj-wrapper',
}

export interface IMJMLJsonObject {
    tagName: EMJMLTag;
    attributes: object;
    children?: IMJMLJsonObject[];
    content?: string;
}
