import React from 'react';

import Box from 'components/Box/Box';
import Text from 'components/Text/Text';
import Heading from 'components/Heading/Heading';

export const withInfo = (Story, context) => {
    const {title, comment} = context.parameters.info || {};

    if (!title && !comment) {
        return <Story {...context} />;
    }

    return (
        <>
            <Box between="1" below="3">
                {title && <Heading level="3">{title}</Heading>}
                {comment && (
                    <div style={{marginBottom: 12}}>
                        <Text color="secondary">{comment}</Text>
                    </div>
                )}
            </Box>
            <Story {...context} />
        </>
    );
};
