const path = require('path');

const {rootPath} = require('../webpack/utilities/getPathParams');

const {mdxWebpackRule} = require('./webpack');
const clientWebpackConfig = require('../webpack/client.webpack.config');

module.exports = {
    core: {
        builder: 'webpack5',
    },
    typescript: {reactDocgen: 'none'},
    stories: [
        `../src/${
            process.env.STORYBOOK_BUILD_TARGET || '**/*'
        }.@(stories|story).@(js|jsx|ts|tsx|mdx)`,
    ],
    addons: [
        '@storybook/addon-essentials',
        '@storybook/addon-toolbars',
        '@storybook/addon-viewport',
    ],
    webpackFinal: async config => {
        config.plugins.push(...clientWebpackConfig.plugins);
        config.resolve.extensions.push('.scss');
        config.optimization.minimizer = [];
        config.resolve.alias = {
            ...clientWebpackConfig.resolve.alias,
            storybook: path.join(rootPath, '.storybook'),
        };

        //  Сделано с целью отключить DefinePlugin в сборке сторибука, из-за конфликта преобразования переменной process.env в сторибуке и его расширения в других библиотеках:
        // - Сторибук - https://github.com/storybookjs/storybook/blob/c064e3e6570ad0f224f11da7bc3ff20b6e4ab781/lib/core-common/src/utils/envs.ts#L64
        // - Другие библиотеки (например @yandex-int/messenger.widget): `process.env = Object.assign({}, process.env);`
        //
        // В этом случае значение prosess.env в DefinePlugin реплейсится, код падает.
        // Если из сторибука уберут `envs['process.env'] = JSON.stringify(raw)`,
        // тогда костыль можно будет удалять
        const definePlugin = config.plugins.find(
            plugin =>
                plugin &&
                plugin.definitions &&
                Object.prototype.hasOwnProperty.call(
                    plugin.definitions,
                    'process.env',
                ),
        );

        if (definePlugin) delete definePlugin.definitions['process.env'];

        return {
            ...config,
            module: {
                ...config.module,
                rules: [mdxWebpackRule, ...clientWebpackConfig.module.rules],
            },
            resolveLoader: {
                ...config.resolveLoader,
                ...clientWebpackConfig.resolveLoader,
            },
        };
    },
};
