import {ReactNode, FunctionComponent} from 'react';
import {Parameters} from '@storybook/react';
import {BaseDecorators} from '@storybook/addons';

interface ICustomParameters extends Parameters {
    info?: {
        title?: ReactNode;
        comment?: ReactNode;
    };
}

interface IStaticStorybookComponent {
    parameters?: ICustomParameters;
    decorators?: BaseDecorators<ReactNode>;
}

export type TStorybookFunctionComponent<T = {}> = FunctionComponent<T> &
    IStaticStorybookComponent;
