const createCompiler = require('@storybook/addon-docs/mdx-compiler-plugin');

const {isDevelopment} = require('../webpack/variables');

const mdxWebpackRule = {
    test: /\.(stories|story)\.mdx$/,
    use: [
        {
            loader: 'babel-loader',
            options: {
                cacheDirectory: isDevelopment,
                cacheCompression: false,
                presets: [
                    [
                        '@babel/preset-env',
                        {
                            targets: {
                                browsers: ['last 2 versions', 'ie >= 11'],
                            },
                            modules: false,
                            useBuiltIns: 'entry',
                        },
                    ],
                    '@babel/preset-react',
                    ['@babel/preset-typescript', {allowNamespaces: true}],
                ],
                plugins: ['@babel/plugin-syntax-dynamic-import'],
            },
        },
        {
            loader: '@mdx-js/loader',
            options: {
                compilers: [createCompiler({})],
            },
        },
    ],
};

module.exports = {
    mdxWebpackRule,
};
