declare module '@yandex-data-ui/ch-stats-client' {
    interface CHStatsClientConfig {
        host: string;
        database: string;
        table: string;
        auth: string | undefined;
    }

    interface CHStatsClientAPIConfig {
        service: string;
        status: number;
        requestId: string;
        requestTime: number;
        requestMethod: string;
        requestUrl: string;
    }

    export default class Clickhouse {
        constructor(config: CHStatsClientConfig);

        sendQuery(sql: string): Promise;

        sendAPIStats(config: CHStatsClientAPIConfig): Promise;
    }
}
