type TWidgetType = 'offers' | 'sku' | 'sku' | 'specifications' | 'reviews';

type TYandexMarketWidgetType =
    | 'constructor'
    | 'models'
    | 'offers'
    | 'beruModels'
    | 'beruOffers';

type TCurrency = 'RUB' | 'BYN' | 'KZT';

type TYandexMarketThemeId = number;

interface IModelImageData {
    height: number;
    width: number;
    url: string;
}

interface IModelPriceData {
    max: number;
    min: number;
    avg: number;
}

interface IMarketEntity {
    entity: 'model' | 'offer' | 'category';
    id: number | string;
    name: string;
}

interface IMarketCategory extends IMarketEntity {
    entity: 'category';
}

interface IMarketProduct extends IMarketEntity {
    entity: 'model' | 'offer';
    category?: IMarketCategory;
    model?: IMarketModel;
    name: string;
    photo: IModelImageData;
    price?: IModelPriceData;
    rating?: number;
    url: string;
}

interface IMarketModel extends IMarketProduct {
    entity: 'model';
    categoryId: number;
    photo: IModelImageData;
    price?: IModelPriceData;
    rating?: number;
    url: string;
}

interface IMarketConstructorResponse {
    type: TYandexMarketWidgetType;
    containerId: string;
    fallback?: boolean;
    params: {
        clid: number;
        themeId: TYandexMarketThemeId;
        searchText?: string;
        searchModelIds?: number[];
        searchSkuIds?: string[];
        searchCategoryIds?: number[];
    };
    rotate?: boolean | number | string | AnyObject<boolean | number>;
}

interface IMarketWidgetEventData {
    product?: IMarketProduct;
}

type TEventListeners = {
    widgetInsert: (createParams: IMarketConstructorResponse) => void;
    widgetShow: () => void;
    widgetClick: () => void;
    needUserAuthForFavorites: () => void;
    addToFavoritesDone: (data: {product: IMarketModel}) => void;
    removeFromFavoritesDone: (data: IMarketWidgetEventData) => void;
    addToCartDone: (data: IMarketWidgetEventData) => void;
};

type TEventTypes = keyof EventListeners;

interface IMarketWidget {
    on<T extends TEventTypes>(
        eventType: T,
        eventListener: TEventListeners[T],
    ): void;
    once<T extends TEventTypes>(
        eventType: T,
        eventListener: TEventListeners[T],
    ): void;
    off<T extends TEventTypes>(
        eventType?: T,
        eventListener?: TEventListeners[T],
    ): void;
    openModal(): Promise<void>;
    closeModal(): Promise<void>;
    toggleModal(toggleMode?: boolean): Promise<void>;
    getType(): Promise<TWidgetType>;
    getModel?: () => Promise<IMarketModel>;
    getProducts?: () => Promise<IMarketProduct[]>;
    getCurrencyCode(): Promise<TCurrency>;
}

/** https://yandex.ru/support/market-distr/widgets/widgets-code.html */
interface ICreateWidgetParams {
    type: TWidgetType;
    containerId: string;
    fallback: boolean;
    params: {
        clid: number;
        searchModelIds: number[];
        themeId: number;
        buttonLinkType?: string;
        themeRows?: number;
        metrikaCounterId?: number;
    };
}

interface Window {
    /** Виджеты маркета */
    YaMarketAffiliate?: {
        createWidget: (params: ICreateWidgetParams) => Promise<IMarketWidget>;
        destroyWidget: (widget: IMarketWidget) => void;
    };
}
