# Ферма

<!-- toc -->

-   [Поднять стенд вручную](#%D0%BF%D0%BE%D0%B4%D0%BD%D1%8F%D1%82%D1%8C-%D1%81%D1%82%D0%B5%D0%BD%D0%B4-%D0%B2%D1%80%D1%83%D1%87%D0%BD%D1%83%D1%8E)
-   [Подменить бэкенд при создании стенда](#%D0%BF%D0%BE%D0%B4%D0%BC%D0%B5%D0%BD%D0%B8%D1%82%D1%8C-%D0%B1%D1%8D%D0%BA%D0%B5%D0%BD%D0%B4-%D0%BF%D1%80%D0%B8-%D1%81%D0%BE%D0%B7%D0%B4%D0%B0%D0%BD%D0%B8%D0%B8-%D1%81%D1%82%D0%B5%D0%BD%D0%B4%D0%B0)
-   [Поднять стенд через api](#%D0%BF%D0%BE%D0%B4%D0%BD%D1%8F%D1%82%D1%8C-%D1%81%D1%82%D0%B5%D0%BD%D0%B4-%D1%87%D0%B5%D1%80%D0%B5%D0%B7-api)
-   [Как работает ферма](#%D0%BA%D0%B0%D0%BA-%D1%80%D0%B0%D0%B1%D0%BE%D1%82%D0%B0%D0%B5%D1%82-%D1%84%D0%B5%D1%80%D0%BC%D0%B0)
-   [Где живет ферма](#%D0%B3%D0%B4%D0%B5-%D0%B6%D0%B8%D0%B2%D0%B5%D1%82-%D1%84%D0%B5%D1%80%D0%BC%D0%B0)
-   [Как понять почему стенд не работает](#%D0%BA%D0%B0%D0%BA-%D0%BF%D0%BE%D0%BD%D1%8F%D1%82%D1%8C-%D0%BF%D0%BE%D1%87%D0%B5%D0%BC%D1%83-%D1%81%D1%82%D0%B5%D0%BD%D0%B4-%D0%BD%D0%B5-%D1%80%D0%B0%D0%B1%D0%BE%D1%82%D0%B0%D0%B5%D1%82)
-   [Проблемы с фермой](#%D0%BF%D1%80%D0%BE%D0%B1%D0%BB%D0%B5%D0%BC%D1%8B-%D1%81-%D1%84%D0%B5%D1%80%D0%BC%D0%BE%D0%B9)
    -   [Зависания фермы](#%D0%B7%D0%B0%D0%B2%D0%B8%D1%81%D0%B0%D0%BD%D0%B8%D1%8F-%D1%84%D0%B5%D1%80%D0%BC%D1%8B)
    -   [Неудаленные стенды](#%D0%BD%D0%B5%D1%83%D0%B4%D0%B0%D0%BB%D0%B5%D0%BD%D0%BD%D1%8B%D0%B5-%D1%81%D1%82%D0%B5%D0%BD%D0%B4%D1%8B)

<!-- tocstop -->

https://travel.farm.yandex-team.ru/

Ферма — это стенды для ревью и тестирования, которые автоматически поднимаются на создание пулл-реквеста.

## Поднять стенд вручную

Кроме того, создать стенд можно вручную, [перейдя по ссылке](https://travel.farm.yandex-team.ru/create/):

Укажите:

-   Проект `ya-travel`
-   Название ветки в git

## Подменить бэкенд при создании стенда

Подменить пути до бэкендов можно через переменные окружения, например бэкенд отелей можно задать через `BASE_URL_travelAPI` - актуальный список переменных окружения можно посмотреть [в конфиге фронтенда](https://a.yandex-team.ru/arcadia/travel/frontend/portal/server/configs/production.js).

## Поднять стенд через api

Также поднять стенд можно через api фермы, стоит делать это аккуратно, чтобы нечаянно не исчерпать все ресурсы фермы.

```
https://travel.farm.yandex-team.ru/api/generate?project=ya-travel&branch=<branch-name>
```

## Как работает ферма

Ферма умеет создавать и удалять стенды.

-   Когда создается пулл-реквест, то в этот момент триггерится github hook, который создает стенд:
    -   копирует ветку из гитхаба
    -   устанавливает зависимости
    -   выполняет команды указанные в секции `preview-generator.prepare` в [package.json](https://a.yandex-team.ru/arcadia/travel/frontend/portal/package.json)
    -   выполняет команду `npm start`
    -   выполняет команды указанные в секции `outview-generator.prepare` в [package.json](https://a.yandex-team.ru/arcadia/travel/frontend/portal/package.json)
    -   робот `robot-ya-travel` создает комментарий в пулл-реквесте и в связной задаче о том, что стенд создан и указывает на него ссылку.
    -   запускает [билд с тестами](https://teamcity.yandex-team.ru/buildConfiguration/DataUI_YaTravel_YaTravelFrontend_E2ePrTests?mode=branches)
-   При изменении истории коммитов в пулл-реквесте, триггерится тот же hook и стенд пересобирается.
-   При закрытии/мёрже пулл-реквеста, стенд удаляется, и робот пишет в связанную задачу комментарий, что стенд удален.

Ферма обновляет ветку dev на push в ветку.

## Где живет ферма

Код фермы: https://a.yandex-team.ru/arcadia/data-ui/farm

Ферма живет в [qyp.yandex-team.ru/vm/sas/travel-farm2](https://qyp.yandex-team.ru/vm/sas/travel-farm2). Для доступа к тачке нужно состоять в ABC группе [Фронденда Путешествий](https://abc.yandex-team.ru/services/portalvteam) или в подразделении [Группы разработки интерфейсов путешествий](https://staff.yandex-team.ru/departments/yandex_infra_tech_interface_monitoring_dep28024).

Код фермы находится в папке `/projects/farm/`.
Код стендов находится в папке `/farm/`.

Конфигурация nginx лежит в самом проекте фермы в следующих а файлах:

```
/projects/farm/nginx/nginx-api.conf — конфигурация фермы
/projects/farm/nginx/nginx-preview.conf - конфигурация стендов
```

В ферме используется **PM2** для запуска стендов.

Для запуска/остановки/перезапуска основного процесса используется [systemctl](<https://wiki.archlinux.org/index.php/Systemd_(Русский)>).

```
sudo systemctl start farm.service

sudo systemctl stop farm.service

sudo systemctl restart farm.service
```

Так можно смотреть логи:

```
sudo journalctl -u farm
```

В конфиге юнита `/etc/systemd/system/farm.service` уже указаны токены стартрека и гитхаба.

OAuth токены можно найти в [секретнице](https://yav.yandex-team.ru/), авторизуемся от имени `robot-ya-travel`:

-   Ищем в списке секретов `robot-ya-travel`.

-   Используем значение `startrack_oauth_token_production` для переменной окружения `ST_ROBOT_TOKEN` и `github_personal_access_token` для `GH_TOKEN`.

## Как понять почему стенд не работает

-   Посмотреть логи сборки стенда в интерфейсе по ссылке, например, для dev стенда:

```
https://travel.farm.yandex-team.ru/api/logs?project=ya-travel&branch=dev
```

-   Посмотреть логи stdout/stderr определенного стенда в интерфейсе самой фермы (доступно только 300 последних строк из лога);

-   Чтобы посмотреть полный лог, нужно самостоятельно зайти на машинку фермы и посмотреть логи **pm2** (fqdn машинки можно посмотреть в [QYP](https://qyp.yandex-team.ru/vm/sas/travel-farm2)):

```
sudo pm2 list
sudo pm2 logs <id>
sudo pm2 logs <id> --lines 400 --err
```

-   Зайти на машинку фермы и посмотреть логи nginx по пути `/var/log/nginx` в файлах:
    -   `farm.api.error.log` - логи самой фермы
    -   `farm.preview.error.log` - логи инстансов фермы

## Проблемы с фермой

### Зависания фермы

Ферма имеет плавующую проблему зависания в случае проблем при сборке стендов, т.к. процесс фермы не изолирован от процессов сборки (дочерние процессы).

В случае зависания необходимо:

1. Проверить доступность фермы по ssh `ssh travel-farm2.sas.yp-c.yandex.net`:
    1. Если машина не доступна, то перезагрузить её в интерфейсе [QYP](https://qyp.yandex-team.ru/vm/sas/travel-farm2);
    2. Если машина доступна, то перезагрузить процесс фермы: `sudo systemctl restart farm.service`;
2. Проверить, что стенды были подняты вместе с фермой, если этого не произошло, то:
    1. Проверить, что значение переменной окружения `echo $PM2_HOME` равно `/projects/farm/.pm2`. Если не равно, то задать это значение.
    2. Перезапустить стенды: `sudo pm2 resurrect`.

### Неудаленные стенды

Иногда неумершие стенды нужно удалять руками, чтобы освободить ресурсы. Такое происходит, когда автоматика на закрытие стендов не сработала или сработала некорректно. Например, обновили пулл-реквест и тут же его замержили. Это происходит потому что одновременно выполняется две операции: создание стенда и его удаление.
В таком случае требуется зайти на [ферму](https://travel.farm.yandex-team.ru/) и попробовать удалить стенд.
Если ферма не может удалить стенд, то нужно зайти на тачку с фермой, удалить pm2 процесс для этого стенда, если он есть и удалить соотвествующую директорию: `/farm/ya-travel/<branch-name>`.
