# Lighthouse scores

Для того чтобы измерить влияние фичи на lighthouse метрики до того как она выехала в прод используется сравнительное тестирование через `npm run lighthouse:compare`

## Параметры:

-   `--first-url` - контрольный урл для сравнения
-   `--second-url` - урл направленный на стенд с фичой
-   `-i, --iterations` - кол-во прогонов (результаты прогонов могут иметь существенные погрешности, поэтому требуется осуществить n прогонов для вычисления средних значений. По-умолчанию кол-во прогонов - 10)
-   `-d, --desktop` - десктопный запуск (по умолчанию измеряем баллы для мобилок)
-   `-r, --report` - флаг вывода результатов сравнения в html файл

## Пример запуска:

`npm run lighthouse:compare -- -i 20 --first-url=https://ya-travel_dev.travel.farm.yandex.ru/ --second-url=https://ya-travel_travelfront-5882.travel.farm.yandex.ru/ -r`

## Метрики

-   `score` - Общая оценка
-   `fcp` (First Contentful Paint) - Время отображения хоть какого-то контента
-   `lcp` (Largest Contentful Paint) - Время отображения самого большого элемента на экране
-   `speedIndex` - Время, отражающее, как быстро отображается контент на странице во время загрузки
-   `tti` (Time To Interactive) - Время до момента, когда пользователь может нормально взаимодействовать со страницей
-   `tbt` (Total Blocking Time) - Общее время блокировки основного потока долгими задачами (сверх 50мс). Т.е. если задача длится 70мс, то в tbt учтется только 20мс.
-   `cls` (Cumulative Layout Shift) - Общий сдвиг макета
-   `maxPotentialFid` - Максимально возможное время ожидания пользователя при первом взаимодействии со страницей
-   `ttfb` (Time To First Byte) - Время до первого байта
-   `mainThreadWork` - Общая продолжительность работы в основном потоке
-   `jsExecutionTime` - Общее время выполнения скриптов
-   `domSize` - Количество элементов в документе
