# Инструкция для дежурного

> **Важно** инструкция обязательна к ознакомлению полностью

<!-- toc -->

-   [Обязанности дежурного](#%D0%BE%D0%B1%D1%8F%D0%B7%D0%B0%D0%BD%D0%BD%D0%BE%D1%81%D1%82%D0%B8-%D0%B4%D0%B5%D0%B6%D1%83%D1%80%D0%BD%D0%BE%D0%B3%D0%BE)
-   [Регламент дежурств](#%D1%80%D0%B5%D0%B3%D0%BB%D0%B0%D0%BC%D0%B5%D0%BD%D1%82-%D0%B4%D0%B5%D0%B6%D1%83%D1%80%D1%81%D1%82%D0%B2)
-   [Как следить за здоровьем сервиса](#%D0%BA%D0%B0%D0%BA-%D1%81%D0%BB%D0%B5%D0%B4%D0%B8%D1%82%D1%8C-%D0%B7%D0%B0-%D0%B7%D0%B4%D0%BE%D1%80%D0%BE%D0%B2%D1%8C%D0%B5%D0%BC-%D1%81%D0%B5%D1%80%D0%B2%D0%B8%D1%81%D0%B0)
    -   [Оценка проблем оплаты ЖД на дашборде операций Траста.](#%D0%BE%D1%86%D0%B5%D0%BD%D0%BA%D0%B0-%D0%BF%D1%80%D0%BE%D0%B1%D0%BB%D0%B5%D0%BC-%D0%BE%D0%BF%D0%BB%D0%B0%D1%82%D1%8B-%D0%B6%D0%B4-%D0%BD%D0%B0-%D0%B4%D0%B0%D1%88%D0%B1%D0%BE%D1%80%D0%B4%D0%B5-%D0%BE%D0%BF%D0%B5%D1%80%D0%B0%D1%86%D0%B8%D0%B9-%D1%82%D1%80%D0%B0%D1%81%D1%82%D0%B0)
    -   [Задержка заказов на дашборде](#%D0%B7%D0%B0%D0%B4%D0%B5%D1%80%D0%B6%D0%BA%D0%B0-%D0%B7%D0%B0%D0%BA%D0%B0%D0%B7%D0%BE%D0%B2-%D0%BD%D0%B0-%D0%B4%D0%B0%D1%88%D0%B1%D0%BE%D1%80%D0%B4%D0%B5)
-   [Начало и завершение дежурства](#%D0%BD%D0%B0%D1%87%D0%B0%D0%BB%D0%BE-%D0%B8-%D0%B7%D0%B0%D0%B2%D0%B5%D1%80%D1%88%D0%B5%D0%BD%D0%B8%D0%B5-%D0%B4%D0%B5%D0%B6%D1%83%D1%80%D1%81%D1%82%D0%B2%D0%B0)
-   [Чаты и боты](#%D1%87%D0%B0%D1%82%D1%8B-%D0%B8-%D0%B1%D0%BE%D1%82%D1%8B)
-   [Релиз](#%D1%80%D0%B5%D0%BB%D0%B8%D0%B7)
    -   [Релизный цикл](#%D1%80%D0%B5%D0%BB%D0%B8%D0%B7%D0%BD%D1%8B%D0%B9-%D1%86%D0%B8%D0%BA%D0%BB)
        -   [Необходимые проверки перед выкаткой релиза](#%D0%BD%D0%B5%D0%BE%D0%B1%D1%85%D0%BE%D0%B4%D0%B8%D0%BC%D1%8B%D0%B5-%D0%BF%D1%80%D0%BE%D0%B2%D0%B5%D1%80%D0%BA%D0%B8-%D0%BF%D0%B5%D1%80%D0%B5%D0%B4-%D0%B2%D1%8B%D0%BA%D0%B0%D1%82%D0%BA%D0%BE%D0%B9-%D1%80%D0%B5%D0%BB%D0%B8%D0%B7%D0%B0)
        -   [Краткое описание релизного цикла](#%D0%BA%D1%80%D0%B0%D1%82%D0%BA%D0%BE%D0%B5-%D0%BE%D0%BF%D0%B8%D1%81%D0%B0%D0%BD%D0%B8%D0%B5-%D1%80%D0%B5%D0%BB%D0%B8%D0%B7%D0%BD%D0%BE%D0%B3%D0%BE-%D1%86%D0%B8%D0%BA%D0%BB%D0%B0)
        -   [Чеклист проверки релиза на окружении после выкатки](#%D1%87%D0%B5%D0%BA%D0%BB%D0%B8%D1%81%D1%82-%D0%BF%D1%80%D0%BE%D0%B2%D0%B5%D1%80%D0%BA%D0%B8-%D1%80%D0%B5%D0%BB%D0%B8%D0%B7%D0%B0-%D0%BD%D0%B0-%D0%BE%D0%BA%D1%80%D1%83%D0%B6%D0%B5%D0%BD%D0%B8%D0%B8-%D0%BF%D0%BE%D1%81%D0%BB%D0%B5-%D0%B2%D1%8B%D0%BA%D0%B0%D1%82%D0%BA%D0%B8)
    -   [Выкатка в testing](#%D0%B2%D1%8B%D0%BA%D0%B0%D1%82%D0%BA%D0%B0-%D0%B2-testing)
        -   [Тестирование](#%D1%82%D0%B5%D1%81%D1%82%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D0%B5)
    -   [Выкатка в prestable](#%D0%B2%D1%8B%D0%BA%D0%B0%D1%82%D0%BA%D0%B0-%D0%B2-prestable)
        -   [Тестирование](#%D1%82%D0%B5%D1%81%D1%82%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D0%B5-1)
    -   [Выкатка в production](#%D0%B2%D1%8B%D0%BA%D0%B0%D1%82%D0%BA%D0%B0-%D0%B2-production)
        -   [Для Qloud (depricated - опциональный шаг, если вы не знаете зачем он вам не делайте его)](#%D0%B4%D0%BB%D1%8F-qloud-depricated---%D0%BE%D0%BF%D1%86%D0%B8%D0%BE%D0%BD%D0%B0%D0%BB%D1%8C%D0%BD%D1%8B%D0%B9-%D1%88%D0%B0%D0%B3-%D0%B5%D1%81%D0%BB%D0%B8-%D0%B2%D1%8B-%D0%BD%D0%B5-%D0%B7%D0%BD%D0%B0%D0%B5%D1%82%D0%B5-%D0%B7%D0%B0%D1%87%D0%B5%D0%BC-%D0%BE%D0%BD-%D0%B2%D0%B0%D0%BC-%D0%BD%D0%B5-%D0%B4%D0%B5%D0%BB%D0%B0%D0%B9%D1%82%D0%B5-%D0%B5%D0%B3%D0%BE)
        -   [Для YDeploy](#%D0%B4%D0%BB%D1%8F-ydeploy)
        -   [Далее](#%D0%B4%D0%B0%D0%BB%D0%B5%D0%B5)
        -   [Тестирование](#%D1%82%D0%B5%D1%81%D1%82%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D0%B5-2)
    -   [Выкатка с zero diff в Qloud](#%D0%B2%D1%8B%D0%BA%D0%B0%D1%82%D0%BA%D0%B0-%D1%81-zero-diff-%D0%B2-qloud)
-   [Релиз pdf-ницы](#%D1%80%D0%B5%D0%BB%D0%B8%D0%B7-pdf-%D0%BD%D0%B8%D1%86%D1%8B)
-   [Действия при возникновении факапа](#%D0%B4%D0%B5%D0%B9%D1%81%D1%82%D0%B2%D0%B8%D1%8F-%D0%BF%D1%80%D0%B8-%D0%B2%D0%BE%D0%B7%D0%BD%D0%B8%D0%BA%D0%BD%D0%BE%D0%B2%D0%B5%D0%BD%D0%B8%D0%B8-%D1%84%D0%B0%D0%BA%D0%B0%D0%BF%D0%B0)
    -   [Что такое факап](#%D1%87%D1%82%D0%BE-%D1%82%D0%B0%D0%BA%D0%BE%D0%B5-%D1%84%D0%B0%D0%BA%D0%B0%D0%BF)
    -   [Действия](#%D0%B4%D0%B5%D0%B9%D1%81%D1%82%D0%B2%D0%B8%D1%8F)
    -   [Хотфикс (без автоматизации)](#%D1%85%D0%BE%D1%82%D1%84%D0%B8%D0%BA%D1%81-%D0%B1%D0%B5%D0%B7-%D0%B0%D0%B2%D1%82%D0%BE%D0%BC%D0%B0%D1%82%D0%B8%D0%B7%D0%B0%D1%86%D0%B8%D0%B8)

<!-- tocstop -->

## Обязанности дежурного

-   Дежурный выкатывает все релизы в период дежурства, включая хотфиксы\*.

    \* Хотфиксы выкатываются в том числе и в выходные.

-   Дежурный следит за здоровьем сервиса - смотрит на приборы и реагирует на мониторинги
-   Дежурный должен быть всегда на связи по телефону и телеграму и быть готовым решать проблемы на сервисе. Выходные дни не являются исключением. \*

\* Если дежурный знает заранее, что у него не будет возможности что-то делать по дежурству в течении длительного времени, то стоит заранее договориться о подмене в это время, с другим дежурным или любым другим коллегой.

> **NB** Дежурство в том числе означает, что дежурный должен находится у своего ноутбука и около точки доступа в интернет.

## Регламент дежурств

Мы дежурим по неделе, со среды 11 утра по следующую среду 11 утра.

> **NB** Эстафетная палочка передается в среду, но если в данный момент в процессе раскатки сложный релиз, его докатывает предыдущий дежурный.

Каждую неделю у нас есть **основной** и **запасной** дежурный, а также дежурный тестировщик.

> **NB** Запасной дежурный должен быть готов в любой момент подхватить обязанности основного дежурного, то есть быть на связи и с ноутбуком.

> **NB** **В престейбл и продакшн релиз всегда катит основной или запасной дежурный.** Посмотреть график дежурств можно в [ABC](https://abc.yandex-team.ru/services/portalvteam/duty/).

> **NB** В тестинг релиз катит дежурный тестировщик. Посмотреть график дежурств тестировщиков можно в [ABC](https://abc.yandex-team.ru/services/yt_qas/duty/).

## Как следить за здоровьем сервиса

Основные показатели, на которые должен смотреть дежурный это количество ошибок на клиенте и на сервере, а также сколько ресурсов потребляет сервис.

Для того, чтобы посмотреть на все показатели у нас есть общий [Дэшборд здоровья сервиса][travel-health-dashboard], где можно увидеть:

-   Ошибки на сервере
-   Ошибки на клиенте
-   Realtime метрики живости сервиса
-   Время ответа и статусы бэкендов
-   Графики денег

Кроме того [настроены мониторинги](logs-and-monitoring.md), которые сообщат дежурному, если что-то пошло не так.

Релизы большинства сервисов путешествий можно видеть в [infra][infra-releases]. Таким образом можно контролировать появление ошибок связанных с релизами сервисов, от которых зависит наше приложение.

### Оценка проблем оплаты ЖД на дашборде операций Траста.

При росте числа ошибок при оплате ЖД может быть полезен [дашборд Траста по операциям](https://solomon.yandex-team.ru/?project=trust&service_id=s171&dashboard=payment_resp_codes&currency=&b=1h&e=).
Если время красных столбиков на [Дaшборде здоровья сервиса][travel-health-dashboard] соответствует всплескам таких ошибок:

-   `authorization_reject`
-   `expired_card`
-   `not_enough_funds`
-   `fail_3ds`
-   `blacklisted`

то проблема связана с «набегом» мошенников.

Каждое падение и проблемы на стороне Траста необходимо фиксировать в [задаче](https://st.yandex-team.ru/TRAVELBACK-2947).

### Задержка заказов на дашборде

Возникают ситуации, когда на [дашборде](https://datalens.yandex-team.ru/huurcsd89uwse-travel-frontend?tab=Dm7) данные о заказах поступают с задержкой.

Чтобы убедиться, что всё в порядке, нужно:

-   Проверить, что есть заказы в [админке заказов](https://travel-orders-admin.yandex-team.ru/) за время с задержкой
-   Проверить насколько отстают данные в CPA, [дашборд для ж/д](https://solomon.yandex-team.ru/?project=travel&cluster=push_prod&service=cpa&dashboard=travel-cpa-train&l.yt_proxy=hahn) нижний левый график
    «Orders lag (minutes)» [ссылка на график](https://solomon.yandex-team.ru/?project=travel&cluster=push_prod&service=cpa&category=train&yt_proxy=hahn&graph=travel-cpa-orders-lag).
    На графике показано время доезжания данных в минутах, должно быть в районе 10-20 минут. Если время больше, тогда мы понимаем, что проблема не с заказами, а с доездом данных и смотрим по админке (первая ссылка), есть ли заказы.

О причинах задержки можно уточнить у [Евгения Чебанова](https://staff.yandex-team.ru/alittleprince)

## Начало и завершение дежурства

Чтобы каждый новый дежурный мог ознакомится с текущим положением дел, мы ведем [лог дежурств][travel-duty-log].

Перед началом дежурства стоит ознакомится с прошедшими инциндентами, а также понять есть ли текущие проблемы и как с ними предлагается в логе работать.

По завершению дежурства стоит добавить свое дежурство в лог.

## Чаты и боты

-   [Travel_Frontend_Alerts](https://t.me/travel_frontend_alerts) - чат для мониторингов, cюда пишутся сообщения о срабатывании мониторингов.
-   [Travel_Frontend_Duty](https://t.me/+oq337X-kRLE2YTQ6) - чат для сообщений релизной машины, а также других связанный с релизом оповещений
-   [Travel Duty](https://t.me/joinchat/UZANynNxMCMPyedP) - чат, дежурств сервиса Travel, можно найти дежурного по любой части продукта, решить насущную проблему.

## Релиз

> **Важно** Релизы не выкатаваются **во время учений**.

> **Важно** Хотфиксы катятся в любой день, в том числе и в выходные.

> **Важно** **Релиз всегда катит основной или запасной дежурный.** Посмотреть график дежурств можно в [ABC](https://abc.yandex-team.ru/services/portalvteam/duty/).

### Релизный цикл

#### Необходимые проверки перед выкаткой релиза

-   приборы показали, что предыдуший релиз успешно раскатился на **продакшн** и не вызвал проблем.

-   предыдущий релиз замержен в **master** и **dev**, тикеты закрыты.

#### Краткое описание релизного цикла

1. Релиз собирается дежурным тестировщиком по кнопке в [Тимсити](https://teamcity.yandex-team.ru/buildConfiguration/DataUI_YaTravel_YaTravelFrontend_CreateRelease), после чего автоматически выкатывается на **testing**. Автоматически созданая релизная задача переводится в статус "можно тестировать".

2. После успешного завершения тестирования, релиз выкатывается основным или запасным дежурным в **prestable**.

    **Дежурный проверяет живость окружения по чеклисту.**

3. После успешного завершения тестирования, релиз выкатывается основным или запасным дежурным в **production**.

    **Дежурный проверяет живость окружения по чеклисту.**

#### Чеклист проверки релиза на окружении после выкатки

1. После того как окружение раскатилось, заходим на него и проверяем, что загружается главная страничка.
2. В течение получаса-часа после релиза смотрим на [Дэшборд здоровья сервиса][travel-health-dashboard]
    - слушаем **мониторинги**
    - проверяем не увеличился ли **фон ошибок** сервера и не падают ли инстансы
    - проверяем по графику **ErrorBooster** не увеличился ли **фон всех ошибок**, можно смотреть график за сутки
    - смотрим на графики Соломона, если события успешной покупки резко упали или увеличилось количество ошибок, нужно выяснять причину

### Выкатка в testing

-   Релиз собираем автоматически с помощью релизной машины, чтобы собрать новый релиз на тестинг надо запустить сборку в [Тимсити](https://teamcity.yandex-team.ru/buildConfiguration/DataUI_YaTravel_YaTravelFrontend_CreateRelease), которая

    -   создаст релизный тикет с именем `TRAVELFRONT-{номер тикета}`
    -   создаст от текущей версии ветки **dev** ветку `TRAVELFRONT-{номер тикета}-release`
    -   после успешной сборки задеплоит новую версия в окружение **testing**
    -   после успешного деплоя, переведет релизный тикет в статус `"можно тестировать"`
    -   создаст PR из ветки `TRAVELFRONT-{номер тикета}-release` в ветку `master`

-   По завершению тестирования, выкатываем релиз в **prestable**.

> **Важно** В релиз попадают задачи, которые **протестированы и замержены**.

> **NB** Если в процессе тестирования были обнаружены проблемы и сделаны фиксы в релизную ветку, собрать новую версию релиза можно с помощью сборки `BuildAndDeploy` и выбранной релизной веткой в UI TeamCity.

#### Тестирование

-   Ответственный QA-инженер\* приступает к тестированию релиза.
-   Если во время тестирования обнаруживаются проблемы, то создается ветка с фиксом и PR в релизную ветку. Комиты с фиксами необходимо cherry-pick-нуть в **dev**.
-   При отсутствии проблем тикет переводится в статус `"протестировано"`.

\* Дежурный тестировщик

### Выкатка в prestable

-   При смене статуса в релизном тикете на "Протестировано", срабатывает задача в TeamCity [on-release-tested](https://teamcity.yandex-team.ru/buildConfiguration/DataUI_YaTravel_YaTravelFrontend_ReleaseFlow_OnReleaseTested). Она запускает выкатку релиза в prestable.

#### Тестирование

-   Ответственный QA-инженер\* приступает к тестированию.
-   Если во время тестирования обнаруживаются проблемы, то создается ветка с фиксом и PR в релизную ветку.
    -   Комиты с фиксами необходимо cherry-pick-нуть в **dev**.
    -   Проводим выкатку в prestable через тестинг в ручном режиме (таской `BuildAndDeploy` и ручным обновлением prestable).
-   Смотрим на приборы по чеклисту. \*

\* Сейчас смотреть на приборы в prestable особого смысла нет, потому что в нем нет пользовательского трафика, но когда-нибудь в будущем будет реализована схема со сплитом production-трафика в prestable (определенный процент пользователей будет попадать в prestable)

### Выкатка в production

-   Дежурный тестировщик уведомляет, что релиз можно катить в production

#### Для Qloud (depricated - опциональный шаг, если вы не знаете зачем он вам не делайте его)

-   В [qloud](https://qloud-ext.yandex-team.ru/projects/travel/front-next/production) находим компонент **ui** и нажимаем кнопку **Update**
-   В поле _tags_ указываем версию, соответствующую версии компонента **ui** в **testing**
-   Нажимаем кнопку **Update**

#### Для YDeploy

-   заходим в [production](https://deploy.yandex-team.ru/stages/travel-frontend-portal-production), выбираем вкладку "Deploy tickets" и нажимаем кнопку "commit" для свежего релиза

#### Далее

-   Повторяем шаги для выкатки в **prestable**
-   По окончанию деплоя уведомить об этом [дежурного тестировщика][qa-duty]
-   По завершению тестирования и наблюдения по чеклисту, дежурный тестировщик переводит релиз в статус "Закрыт"
-   После чего автоматика мержит релизный PR в мастер и отправляет сообщение в Duty чат о необходимости замержить master в dev.
    -   Если автоматика не смогла смержить релиз в master, то делаем это вручную. В релизном PR проверяем, что выбран режим **Merge pull request** (данный PR нельзя сквошить, из-за этого возникают конфликты) и мержим релизную ветку в мастер, через **мерж-коммит** и **без сквоша коммитов**.
-   Создаем пулреквест из **master** в **dev** , проверяем, что выбран режим **Merge pull request** и мержим также, через **мерж-коммит** и **без сквоша коммитов**.

> **NB** Если при попытке замержить **master** в **dev**, есть конфликты, убедитесь что в мастере не появился комит вида **Merge branch 'dev' into master**, например, происходит при попытке резолвить конфликты в интерфейсе гитхаба, это может привести к неприятным спецэффектам.

#### Тестирование

-   После выкатки релиза в `production` призываем в тикет [дежурного тестировщика][qa-duty] - он проверяет, что `production` работает.
-   Смотрим на приборы по чеклисту.
-   После этого дежурный тестировщик закрывает релизные таски.

### Выкатка с zero diff в Qloud

При возникновении необходимости перезапустить все процессы приложения на всех инстансах можно воспользоваться zero diff deploy. Для этого, не меняя версию docker образа, нужно создавать новый draft и указать на вкладке variables любую новую переменную окружения. После этого запустить deploy.

## Релиз pdf-ницы

-   Выкатываем нужную ветку в **testing** таском в [тимсити](https://teamcity.yandex-team.ru/buildConfiguration/DataUI_YaTravel_YaTravelPdf_BuildAndDeploy?branch=%3Cdefault%3E&buildTypeTab=overview).
-   Переводим тикет в статус можно тестировать pdf-ницу, передаем задачу тестировщику.
-   После окончания тестирования выкатываем пдфницу в **production**. Для этого в [проекте qloud](https://qloud-ext.yandex-team.ru/projects/travel/tools/production?version=1569248731935) обновляем компонент **pdf** до последней версии.
-   Оповещаем дежурного тестировщика, что необходимо протестировать pdf-ницу в **production**
-   Если проблем с релизом нет, вливаем релизную ветку в мастер.

## Действия при возникновении факапа

Подробно про то, что такое LSR и полный регламент действий смотрит [в общей документации](https://docs.yandex-team.ru/travel/org/lsr)

### Что такое факап

Коротко:

-   Появилось много ошибок на клиенте
-   Появилось много пятисоток на сервере (не апстримы)
-   Перестали работать заказы или другая критическая функциональность (критичность определяет менеджер вертикали и/или дежурный тестировщик)

Актуальная документация [тут](https://docs.yandex-team.ru/travel/org/lsr#kriterii-incidenta)

### Действия

1. Дежурный разработчик, менеджер вертикали и дежурный тестировщик - принимают решение откатывать ли релиз или чинить, в зависимости от критичности проблему и/или прогнозируемой скорости починки.
2. Починка
    - Выкатываем предыдущую стабильную версию - если проблема не ждет нового релиза и связана с предыдущим релизом.
    - Делаем [хотфикс](#%D1%85%D0%BE%D1%82%D1%84%D0%B8%D0%BA%D1%81-%D0%B1%D0%B5%D0%B7-%D0%B0%D0%B2%D1%82%D0%BE%D0%BC%D0%B0%D1%82%D0%B8%D0%B7%D0%B0%D1%86%D0%B8%D0%B8) - если проблема не может ждать нового релиза и не связана с предыдущими.
    - Фиксим проблему и выкатываем фикс в рамках нового релиза - если проблема не связана с предудыщим релизом и может подождать.
3. Дежурный заводит lsr тикет, [как описано в инструкции](<https://docs.yandex-team.ru/travel/org/lsr#shablon-lsr-(dlya-viki)>) и предоставляет туда необходимую информацию по инциденту.

### Хотфикс (без автоматизации)

Текущая схема с релизами не позволяет быстро выкатывать хотфиксы и частично инкрементировать версию.

1. Сообщаем всем отвественным и приостановливаем выкатку релизов.
2. Создаем релизную ветку от текущего master, готовим хотфикс.
3. Обновляем номер последней версии в `.build`:

    3.1. Если есть активный релиз, черрипикаем коммит с инкрементом версии, из ветки этого релиза (ручное обновление номера создаст конфликты).

    3.2. При отсутствии активного релиза проверяем, что номер совпадает с dev.

4. Выкатываем релизную ветку в **testing** таском в [тимсити](https://teamcity.yandex-team.ru/buildConfiguration/DataUI_YaTravel_Testing).
5. Дальнейшая выкатка совпадает с релизным флоу.
6. После выкатки в **production** и по завершению тестирования и наблюдения по чеклисту:

    6.1. Мерджим пулл реквест в master.

    6.2. Мерджим master в dev.

    6.3. Создает Pull-Request из ветки хотфикса в активную релизную ветку и мержим.

[travel-health-dashboard]: https://dash.yandex-team.ru/huurcsd89uwse
[travel-duty-log]: https://wiki.yandex-team.ru/users/sirinity13/travelfrontend/duty-logs/
[qa-duty]: https://abc.yandex-team.ru/services/yt_qas/duty/
[lsr-template]: https://wiki.yandex-team.ru/travel/duty/lsr-template/
[infra-releases]: https://infra.yandex-team.ru/timeline?preset=all&autorefresh=false&status=all&filter=travel&fullscreen=false
