Итак, вы хотите отправлять свои метрики в [соломон](https://wiki.yandex-team.ru/solomon).
Для метрик доступно 3 вида сенсоров - DGAUGE, COUNTER и RATE ([описание](https://wiki.yandex-team.ru/solomon/userguide/datamodel/#types)). Им соответствуют экспортируемые функции [тут](../tools/solomon/utils/sensors.js).

### Использование

1. Для работы импортим в нужное место нужный сенсор

```
import {counter} from '../../../tools/solomon';
```

2. Дергаем сенсор. Сенсор - это его имя и опциональные лейблы. Для всех видов сенсоров первый аргумент - имя сенсора, второй - лейблы(Record опциональных меток). Пока что предлагаю для продуктовых нужд имя сенсора начинать с вертикали, а за слешом - как угодно. Для инфраструктурных метрик - по ситуации. Ограничения - имя сенсора строкового типа не длиннее 32. В лейблах - имя лейбла не длиннее 32, значение лейбла - строкового типа не длиннее 199, количество меток в лейблах - не более 14 (на самом деле 16, но 2 используются под имя сенсора и pid воркера).

```
await counter(
    'Vertical/sensorName'
    {
        platform: 'mobile'
        status: 'success'
    },
);
```

или

```
await gauge(
    'push-client',
    {
        log_name: 'json_redir',
        type: 'commit_delay
    },
    160000
);
```

3. Настройка графика в solomon.yandex-team.ru/admin/projects/travel-frontend. Начало доки тут https://wiki.yandex-team.ru/solomon/userguide/begin/.

В проде используется кластеризация, поэтому приходится инициализировать хранилище для соломона на мастере и с воркерами перекидываться сообщениями через ipc. Само хранилище находится в пакете [sensors](https://a.yandex-team.ru/arcadia/travel/frontend/sensors). Сама библиотека позволяет один раз создать сенсор и работать с ним напрямую, но из-за кластеризации нельзя пошарить память между воркерами.

В деве значения не собираются (Но можно сделать логгирование).
